/*
 * This file is a part of the gnetsentry project.
 * Copyright (C) 1998 Martin Gall
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*
 *
 */

#ifndef LAY_TCP_H
#define LAY_TCP_H	1

#include "layer.h"
#include "lay_ip.h"

typedef u_int		t_tcp_seq;

typedef struct		s_tcphdr 
{
  u_short		th_sport;
  u_short		th_dport;
  t_tcp_seq		th_seq; 
  t_tcp_seq		th_ack; 
#ifndef HAVE_BITFIELDS
  u_char		th_offx2;	
#else 
# ifndef WORDS_BIGENDIAN 
  u_char		th_x2:4;
  u_char		th_off:4;
# else
  u_char		th_off:4;
  u_char		th_x2:4;
# endif
#endif
  u_char		th_flags;
  u_short		th_win;
  u_short		th_sum;
  u_short		th_urp;
} t_tcphdr;

#define TCP_MAXWIN	65535

#define TH_FIN		0x01
#define TH_SYN		0x02
#define TH_RST		0x04
#define TH_PUSH		0x08
#define TH_ACK		0x10
#define TH_URG		0x20

#define TCP_HLEN	20

#define LAYER_TCP_CHECK(tcppar,bufpar,lenpar) \
	if ((lenpar) < TCP_HLEN)\
		return (-ERR_TRUNC);\
	(tcppar) = (t_tcphdr *)(bufpar);

/*
 * mba_ prefix means "must be aligned", i.e. mba_seq in tcp_get_seq().
 */

/* PROTO lay_tcp.c */
/* lay_tcp.c */
unsigned short tcp_cksum P((t_ip *ip));
void tcp_compute_sum P((t_ip *ip));
void tcp_set_proto P((t_ip *ip));
void tcp_set_sport P((t_tcphdr *tcphdr, int sport));
int tcp_get_sport P((t_tcphdr *tcphdr));
void tcp_set_dport P((t_tcphdr *tcphdr, int dport));
int tcp_get_dport P((t_tcphdr *tcphdr));
void tcp_set_seq P((t_tcphdr *tcphdr, t_tcp_seq seq));
void tcp_get_seq P((t_tcphdr *tcphdr, t_tcp_seq *mba_seq));
void tcp_set_ack P((t_tcphdr *tcphdr, t_tcp_seq ack));
void tcp_get_ack P((t_tcphdr *tcphdr, t_tcp_seq *mba_ack));
void tcp_set_off P((t_tcphdr *tcp, int off));
int tcp_get_off P((t_tcphdr *tcp));
void tcp_set_x2 P((t_tcphdr *tcp, int x2));
int tcp_get_x2 P((t_tcphdr *tcp));
void tcp_set_flags P((t_tcphdr *tcphdr, int flags));
int tcp_get_flags P((t_tcphdr *tcphdr));
void tcp_set_win P((t_tcphdr *tcphdr, int win));
int tcp_get_win P((t_tcphdr *tcphdr));
void tcp_set_sum P((t_tcphdr *tcphdr, int sum));
int tcp_get_sum P((t_tcphdr *tcphdr));
void tcp_set_urp P((t_tcphdr *tcphdr, int urp));
int tcp_get_urp P((t_tcphdr *tcphdr));
t_status tcp_off P((char *buf, int len, off_t *off));
t_status tcp_sub P((char *buf, int len, t_msg_proc *sub_mp));
t_status tcp_sum P((char *buf, int len, char *up_buf, int up_len));
t_status tcp_flags_to_str P((int flags, char *str, int max_len, t_boolean resolve));
t_status tcp_msg P((int msg, void *arg1, void *arg2));
#endif
