/*
 * This file is a part of the gnetsentry project.
 * Copyright (C) 1998 Martin Gall
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*
 *
 */

#ifndef LAY_MSG_H
#define LAY_MSG_H	1

#include "a.h"

typedef struct		s_sum_data
{
  t_buf			b;
  t_buf			up;
} t_sum_data;

typedef struct		s_summarize_data
{
  t_buf			b;
  t_bridled_str		bs;
  t_boolean		resolve;
} t_summarize_data;

typedef struct		s_get_field_data
{
  t_buf			b;
  char			*field;
} t_get_field_data;

#define LAY_NAME			2
#define LAY_NAME_ARGS(inst1,inst2)	ARG2(char **,inst2)

#define LAY_OFF				3
#define LAY_OFF_ARGS(inst1,inst2)	ARG1(t_buf *,inst1);\
					ARG2(off_t *,inst2)

#define LAY_SUB				4
#define LAY_SUB_ARGS(inst1,inst2)	ARG1(t_buf *,inst1);\
					ARG2(t_msg_proc *,inst2)

#define LAY_SUM				5
#define LAY_SUM_ARGS(inst1,inst2)	ARG1(t_sum_data *,inst1)

#define LAY_GET_FIELD			6
#define LAY_GET_FIELD_ARGS(inst1,inst2)	ARG1(t_get_field_data *,inst1);\
					ARG2(t_bridled_str *,inst2)

#define LAY_SET_FIELD			7
#define LAY_SET_FIELD_ARGS(inst1,inst2)	ARG1(t_get_field_data *,inst1);\
					ARG2(char *,inst2)

/* PROTO lay_msg.c */
/* lay_msg.c */
t_status lay_msg P((t_msg_proc mp, int msg, void *arg1, void *arg2));
#endif
