/*
 * This file is a part of the gnetsentry project.
 * Copyright (C) 1998 Martin Gall
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*
 *
 */

#ifndef LAY_ARP_H
#define LAY_ARP_H	1

#include "layer.h"

typedef struct	s_arphdr
{
  u_short	ar_hrd;		/* format of hardware address */
#define ARP_HRD_ETHER 	1	/* ethernet hardware address */
#define ARP_HRD_802	6	/* 802 net hardware address */
  u_short	ar_pro;		/* format of protocol address */
  u_char	ar_hln;		/* length of hardware address */
  u_char	ar_pln;		/* length of protocol address */
  u_short	ar_op;		/* one of: */
#define	ARP_OP_REQUEST	1	/* request to resolve address */
#define	ARP_OP_REPLY	2	/* response to previous request */
  /*	u_char	ar_sha[];	   sender hardware address */
  /*	u_char	ar_spa[];	   sender protocol address */
  /*	u_char	ar_tha[];	   target hardware address */
  /*	u_char	ar_tpa[];	   target protocol address */
} t_arphdr;

#define ARP_HLEN	sizeof (t_arphdr)

#define LAYER_ARP_CHECK(arppar,bufpar,lenpar) \
	if ((lenpar) < ARP_HLEN)\
		return (-ERR_TRUNC);\
	(arppar) = (t_arphdr *)(bufpar);

/* PROTO lay_arp.c */
/* lay_arp.c */
void arp_set_hrd P((t_arphdr *arphdr, int hrd));
int arp_get_hrd P((t_arphdr *arphdr));
void arp_set_pro P((t_arphdr *arphdr, int pro));
int arp_get_pro P((t_arphdr *arphdr));
void arp_set_hln P((t_arphdr *arphdr, int hln));
int arp_get_hln P((t_arphdr *arphdr));
void arp_set_pln P((t_arphdr *arphdr, int pln));
int arp_get_pln P((t_arphdr *arphdr));
void arp_set_op P((t_arphdr *arphdr, int op));
int arp_get_op P((t_arphdr *arphdr));
t_status arp_sub P((char *buf, int len, t_msg_proc *sub_mp));
t_status arp_hrd_to_str P((int hrd, char *str, int max_len, t_boolean resolve));
t_status arp_op_to_str P((int op, char *str, int max_len, t_boolean resolve));
t_status arp_msg P((int msg, void *arg1, void *arg2));
#endif
