/*
 * This file is a part of the gnetsentry project.
 * Copyright (C) 1998 Martin Gall
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*
 *
 */

#ifndef EXP_SCAN_H
#define EXP_SCAN_H	1

#include "exp.h"

#define SCAN_STATE_DEFAULT	0

typedef t_boolean	(*t_scan_drv_match_proc) P((VOID_PTR match_data,
						    char *text,
						    int len,
						    VOID_PTR advice));

typedef int		(*t_scan_drv_cvt_proc) P((VOID_PTR cvt_data,
						  char *text,
						  int len,
						  VOID_PTR advice,
						  VOID_PTR *token));

struct s_scan_drv;

typedef VOID_FUNC	(*t_scan_drv_delete_proc) P((VOID_PTR delete_data,
						     struct s_scan_drv *sd));

typedef struct			s_scan_drv
{	
  int				state;
  int				min_len;
  int				max_len;
  t_scan_drv_match_proc		match;
  VOID_PTR			match_data;
  t_scan_drv_cvt_proc		cvt;
  VOID_PTR			cvt_data;
  t_scan_drv_delete_proc	delete;
  VOID_PTR			delete_data;
} t_scan_drv;

typedef struct			s_scan
{
  t_vec				*drvs;
  int				text_len;
  char				*text;
  char				*buf;
  int				len;
  int				pos;
  t_scan_drv			*drv;
  int				state;
  t_boolean			eob;
} t_scan;

#define SCAN_TOK	0
#define SCAN_EOB	1
#define SCAN_CONT	2			

/* PROTO exp_scan.c */
/* exp_scan.c */
void scan_drv_sd_delete_free_data P((void *delete_data, t_scan_drv *sd));
void scan_drv_sd_delete P((void *delete_data, t_scan_drv *sd));
t_scan *scan_new P((t_status *status));
void scan_delete P((t_scan *scan));
int scan_add_drv P((t_scan *scan, t_scan_drv *drv));
int scan_compute_text_len P((t_scan *scan));
t_status scan_setup_text P((t_scan *scan, int text_len));
t_status scan_setup P((t_scan *scan));
void scan_set_buf P((t_scan *scan, char *buf, int len));
void scan_set_state P((t_scan *scan, int state));
t_status scan_next P((t_scan *scan, void *advice, void **val));
void scan_reset P((t_scan *scan));
void scan_show_text P((t_scan *scan));
void scan_show_drv P((t_scan *scan, t_scan_drv *sd, char *comment));
void scan_drv_show P((t_scan_drv *sd));
#endif
