/*
 * This file is a part of the gnetsentry project.
 * Copyright (C) 1998 Martin Gall
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*
 *
 */

#ifndef EXP_OBJECT_H
#define EXP_OBJECT_H	1

#include "exp_compil.h"

typedef struct			s_object
{
  int				oid;
  VOID_PTR			value;
} t_object;

typedef VOID_FUNC		(*t_object_show_proc) P((t_object *object));
typedef VOID_FUNC		(*t_object_delete_proc) P((t_object *object));
typedef int			(*t_object_dup_proc) P((t_object *src,
							t_object *dst));

typedef struct			s_object_def
{
  char				*name;	
  t_object_show_proc		show;
  t_object_delete_proc		delete;
  t_object_dup_proc		dup;
} t_object_def;

typedef struct			s_object_manager
{
  t_vec				*oids;
  t_dict			*bops;
  t_dict			*uops;
  t_compil			*compil;
  t_vec				*objects;
} t_object_manager;

#define OBJECT_ID_ANY		-1

typedef struct			s_object_manager_bop
{
  int				left_oid;
  int				right_oid;
  int				prio;
  int				assoc;
  t_eval_bop_is_contr_proc	is_contr_proc;
  t_eval_bop_contr_proc		contr_proc;
  t_eval_bop_proc		proc;
  VOID_PTR			data;
} t_object_manager_bop;

typedef struct			s_object_manager_uop
{
  int				operand_oid;
  int				way;
  t_eval_uop_proc		proc;
  VOID_PTR			data;
} t_object_manager_uop;

/* PROTO exp_object.c */
/* exp_object.c */
t_object *object_new P((t_object_manager *om, int oid, t_status *status));
t_object_manager *object_manager_new P((t_compil *compil, t_status *status));
int object_manager_delete_vec_ombops P((t_hash_elt *he, void *data));
int object_manager_delete_vec_omuops P((t_hash_elt *he, void *data));
void object_destroy P((t_object_manager *om, t_object *o));
void object_manager_destroy_objects P((t_object_manager *om));
void object_manager_delete P((t_object_manager *om));
int object_manager_register P((t_object_manager *om, t_object_def *od));
t_boolean object_manager_bop_sd_match P((char *match_data, char *text, int len, t_advice *advice));
int object_manager_bop_do P((t_object_manager_bop *ombop, t_object *left, t_object *right, void **result));
t_status object_manager_bop_eval P((t_vec *data, t_object *left, t_object *right, void **result));
t_status object_manager_bop_sd_cvt P((t_vec *cvt_data, char *text, int len, void *advice, t_token *token));
void object_manager_bop_scan_drv_delete P((t_scan_drv *scan_drv));
void object_manager_bop_sd_delete P((void *delete_data, t_scan_drv *sd));
t_scan_drv *object_manager_bop_scan_drv_new P((char *str, t_object_manager_bop *ombop, t_vec *vec, t_status *status));
t_status object_manager_request_bop P((t_object_manager *om, char *str, t_object_manager_bop *ombop));
t_boolean object_manager_uop_sd_match P((char *match_data, char *text, int len, t_advice *advice));
t_status object_manager_uop_eval P((t_vec *data, t_object *operand, void **result));
t_status object_manager_uop_sd_cvt P((t_vec *cvt_data, char *text, int len, void *advice, t_token *token));
void object_manager_uop_scan_drv_delete P((t_scan_drv *scan_drv));
void object_manager_uop_sd_delete P((void *delete_data, t_scan_drv *sd));
t_scan_drv *object_manager_uop_scan_drv_new P((char *str, t_object_manager_uop *omuop, t_vec *vec, t_status *status));
t_status object_manager_request_uop P((t_object_manager *om, char *str, t_object_manager_uop *omuop));
void object_show P((t_object_manager *om, t_object *o));
t_status object_dup P((t_object_manager *om, t_object *src, t_object **dst));
int object_id_get_from_name P((t_object_manager *om, char *name));
void object_manager_bop_show P((char *str, t_object_manager_bop *ombop));
void object_manager_uop_show P((char *str, t_object_manager_uop *omuop));
#endif
