/*
 * This file is a part of the gnetsentry project.
 * Copyright (C) 1998 Martin Gall
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*
 *
 */

#ifndef EXP_EVAL_H
#define EXP_EVAL_H	1

#include "exp_node.h"

struct s_token;		

typedef int		(*t_eval_item_proc) P((VOID_PTR data,
					       struct s_token *token,
					       VOID_PTR *result));

typedef struct		s_eval_item
{
  t_eval_item_proc	proc;
  VOID_PTR		data;
} t_eval_item;

typedef int		(*t_eval_bop_is_contr_proc) P((VOID_PTR data,
						       VOID_PTR left,
						       t_boolean *ok));
typedef int		(*t_eval_bop_contr_proc) P((VOID_PTR data,
						    VOID_PTR left,
						    VOID_PTR *result));
typedef int		(*t_eval_bop_proc) P((VOID_PTR data,
					      VOID_PTR left,
					      VOID_PTR right,
					      VOID_PTR *result));

typedef struct			s_eval_bop
{
  t_eval_bop_is_contr_proc	is_contr_proc;
  t_eval_bop_contr_proc		contr_proc;
  t_eval_bop_proc		proc;
  VOID_PTR			data;
} t_eval_bop;

typedef int		(*t_eval_uop_proc) P((VOID_PTR data,
					      VOID_PTR operand,
					      VOID_PTR *result));

typedef struct		s_eval_uop
{
  t_eval_uop_proc	proc;
  VOID_PTR		data;
} t_eval_uop;

typedef t_status	(*t_eval_func_proc) P((struct s_token *token,
					       t_node *node,
					       VOID_PTR *result));

typedef int		(*t_eval_proc) P((t_node *node,
					  VOID_PTR *result));

/* PROTO exp_eval.c */
/* exp_eval.c */
t_status eval_node_item P((t_node_item *ni, void **result));
int eval_node_bop P((t_node_bop *nbop, void **result));
int eval_node_uop P((t_node_uop *nuop, void **result));
t_status eval_node_func P((t_node_func *nf, void **result));
int eval_node P((t_node *node, void **result));
void node_show P((t_node *node));
#endif
