/*
 * This file is a part of the gnetsentry project.
 * Copyright (C) 1998 Martin Gall
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*
 *
 */

#ifndef EXP_COMPIL_H
#define EXP_COMPIL_H	1

#include "exp.h"
#include "exp_scan.h"
#include "exp_node.h"
#include "exp_eval.h"
#include "exp_show.h"

#define TOKEN_OPERAND		0
#define TOKEN_BOP		1
#define TOKEN_UOP		2
#define TOKEN_LP		3
#define TOKEN_RP		4

#define BOP_LEFT		0
#define BOP_RIGHT		1

typedef struct			s_advice
{
  int				state;
} t_advice;

typedef struct			s_token_operand
{
  VOID_PTR			value;
  t_eval_item			eval;
} t_token_operand;

typedef struct			s_token_bop
{
  int				prio;
  int				assoc;		/* always BOP_LEFT	*/
  t_eval_bop			eval;
} t_token_bop;

#define UOP_PRE			0
#define UOP_POST		1

typedef struct			s_token_uop
{
  int				prio;		/* unused for the moment*/
  int				way;		/* always UOP_PRE	*/
  t_eval_uop			eval;
} t_token_uop;

typedef union			u_token_union
{
  t_token_operand		operand;
  t_token_bop			bop;
  t_token_uop			uop;
} t_token_union;

typedef struct			s_token
{
  int				token_type;
  VOID_PTR			token_data;
  t_show			token_show;
  t_token_union			token_union;
} t_token;

#define token_operand_value	token_union.operand.value
#define token_operand_eval	token_union.operand.eval
#define token_bop_prio		token_union.bop.prio
#define token_bop_assoc		token_union.bop.assoc
#define token_bop_eval		token_union.bop.eval
#define token_uop_way		token_union.uop.way
#define token_uop_eval		token_union.uop.eval

typedef struct			s_compil
{
  t_scan			*scan;
  int				state;
  int				paren;
  t_vec				*pool;
  int				level;
} t_compil;

typedef struct			s_subcompil
{
  t_compil			*compil;
  t_vec				*operand_stack;
  t_vec				*operator_stack;
} t_subcompil;

#define STATE_INIT		0
#define STATE_EXPR		1
#define STATE_OPERATOR		2

typedef int			(*t_state_proc) P((t_subcompil *subcompil,
						   t_token *token));

typedef int			(*t_token_proc) P((t_subcompil *subcompil,
						   t_token *token));

#define COMPIL_CONT		0
#define COMPIL_RET		1

#define PUSH_OPERAND(sc,operand)	stack_push((sc)->operand_stack,\
						   (VOID_PTR)(operand))
#define LOOKUP_OPERAND(sc,operand)	stack_lookup((sc)->operand_stack,\
						     (VOID_PTR *)(operand))
#define POP_OPERAND(sc,operand)		stack_pop((sc)->operand_stack,\
						  (VOID_PTR *)(operand))
#define PUSH_OPERATOR(sc,operator)	stack_push((sc)->operator_stack,\
						   (VOID_PTR)(operator))
#define LOOKUP_OPERATOR(sc,operator)	stack_lookup((sc)->\
						      operator_stack,\
						      (VOID_PTR *)(operator))
#define POP_OPERATOR(sc,operator)	stack_pop((sc)->operator_stack,\
						  (VOID_PTR *)(operator))

/* PROTO exp_compil.c */
/* exp_compil.c */
t_node_item *node_item_new P((t_vec *pool, t_token *token, t_status *status));
void node_item_delete P((t_node_item *ni));
t_node_item *node_item_dup P((t_vec *pool, t_node_item *ni, t_status *status));
t_compil *compil_new P((t_status *status));
t_subcompil *subcompil_new P((t_compil *compil, t_status *status));
void compil_pool_destroy P((t_compil *compil));
void compil_pool_empty P((t_compil *compil));
void compil_reset P((t_compil *compil));
void compil_delete P((t_compil *compil));
void subcompil_empty_stacks P((t_subcompil *subcompil));
void subcompil_delete P((t_subcompil *subcompil));
void compil_set_buf P((t_compil *compil, char *buf, int len));
t_status push_result P((t_subcompil *subcompil));
t_status check_prio P((t_subcompil *subcompil, t_node_item *operator));
t_status check_uop_and_push P((t_subcompil *subcompil, t_node *node));
t_status state_expr_token_operand P((t_subcompil *subcompil, t_token *token));
t_status state_expr_token_uop P((t_subcompil *subcompil, t_token *token));
t_status state_expr_token_lp P((t_subcompil *subcompil, t_token *token));
t_status state_expr_token_rp P((t_subcompil *subcompil, t_token *token));
t_status state_expr P((t_subcompil *subcompil, t_token *token));
t_status state_operator_token_bop P((t_subcompil *subcompil, t_token *token));
t_status state_operator_token_lp P((t_subcompil *subcompil, t_token *token));
int state_operator_token_rp P((t_subcompil *subcompil, t_token *token));
t_status state_operator P((t_subcompil *subcompil, t_token *token));
t_status compil_sub P((t_compil *compil, t_node **node));
void compil_show_token P((t_compil *compil, t_token *token));
#endif
