/*
 * This file is a part of the gnetsentry project.
 * Copyright (C) 1998 Martin Gall
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*
 *
 */

#ifndef EXP_CLASS_STR_H
#define EXP_CLASS_STR_H	1

#include "exp_class.h"

#define OBJECT_STR_STR		"str"
#define CLASS_STR_STR		"str"

typedef struct			s_object_str_bop_def
{
  char				*pattern;
  int				prio;
  int				assoc;
  t_eval_bop_is_contr_proc	is_contr_proc;
  t_eval_bop_contr_proc		contr_proc;
  t_eval_bop_proc		proc;
} t_object_str_bop_def;

typedef struct			s_class_str_data
{
  t_object_manager		*om;
  int				int_oid;
  int				oid;
  t_vec				*pool;
} t_class_str_data;

extern t_class_def		class_str_def;

/* PROTO exp_class_str.c */
/* exp_class_str.c */
t_boolean cstr_match P((char *str));
t_status str_from_cstr P((char *str, int max_len, char *cstr));
t_status str_to_cstr P((char *cstr, int max_len, char *str));
t_status object_str_plus P((t_class_str_data *data, t_object *left, t_object *right, t_object **result));
t_status object_str_equal P((t_class_str_data *data, t_object *left, t_object *right, t_object **result));
t_boolean object_str_sd_match P((void *data, char *text, int len, void *advice));
t_status object_str_eval P((t_class_str_data *data, t_token *token, t_object **result));
t_status object_str_sd_cvt P((t_class_str_data *data, char *text, int len, void *advice, t_token *token));
void object_str_show P((t_object *o));
void object_str_delete P((t_object *o));
t_status object_str_dup P((t_object *src, t_object *dst));
void object_str_sd_delete P((void *delete_data, t_scan_drv *sd));
t_class_str_data *class_str_data_new P((t_status *status));
void class_str_pool_destroy P((t_class_str_data *data));
void class_str_pool_empty P((t_class_str_data *data));
void class_str_tilde P((t_class_str_data *data));
t_status class_str P((t_object_manager *om, t_class_str_data **data));
#endif
