/*
 * This file is a part of the gnetsentry project.
 * Copyright (C) 1998 Martin Gall
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*
 *
 */

#ifndef EXP_CLASS_H
#define EXP_CLASS_H	1

#include "exp_object.h"

typedef int		(*t_class_proc) P((t_object_manager *om,
						   VOID_PTR *class_data));
typedef VOID_FUNC	(*t_class_tilde_proc) P((VOID_PTR class_data));
typedef VOID_FUNC	(*t_class_pool_destroy_proc) P((VOID_PTR class_data));
typedef VOID_FUNC	(*t_class_pool_empty_proc) P((VOID_PTR class_data));

typedef struct			s_class_def
{
  char				*name;
  t_class_proc			class;
  t_class_tilde_proc		class_tilde;
  t_class_pool_destroy_proc	pool_destroy;
  t_class_pool_empty_proc	pool_empty;
} t_class_def;

typedef struct			s_class_manager
{
  t_object_manager		*om;
  t_vec				*cids;
} t_class_manager;

typedef struct			s_class
{
  t_class_def			*def;
  VOID_PTR			data;
} t_class;

/* PROTO exp_class.c */
/* exp_class.c */
t_class_manager *class_manager_new P((t_object_manager *om, t_status *status));
void class_manager_delete P((t_class_manager *cm));
t_status class_manager_register P((t_class_manager *cm, t_class_def *cd));
t_class *class_get_from_name P((t_class_manager *cm, char *name, t_status *status));
int class_manager P((t_class_manager *cm));
void class_manager_tilde P((t_class_manager *cm));
void class_manager_pool_destroy P((t_class_manager *cm));
void class_manager_pool_empty P((t_class_manager *cm));
#endif
