/*
 * This file is a part of the gnetsentry project.
 * Copyright (C) 1998 Martin Gall
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*
 *
 */

#ifndef EXP_H
#define EXP_H	1

#include "a.h"

#define EXP_ALLOC_PROC		alloc_malloc
#define EXP_FREE_PROC		free_free

#define EXP_VEC_NEW(statusp)	vec_new(VEC_BASE,\
					FALSE,\
					alloc_algorithm_power2,\
					EXP_ALLOC_PROC,\
					EXP_FREE_PROC,\
					(statusp))

#define EXP_DICT_NEW(statusp)	dict_new(HASH_BASE,\
					 VEC_BASE,\
					 dict_hcode_public,\
					 alloc_algorithm_power2,\
					 EXP_ALLOC_PROC,\
					 EXP_FREE_PROC,\
					 (statusp))

extern t_boolean		exp_keep_text;

#ifdef DEBUG
extern t_mask			exp_verb_level;

# define VERB_OBJ_INIT		(1L<<0)
# define VERB_COMPIL		(1L<<1)
# define VERB_SCAN		(1L<<2)
# define VERB_DELETE		(1L<<3)
# define VERB_EVAL		(1L<<4)
# define VERB_OBJ		(1L<<5)

# define EXP_VERB(level)	((exp_verb_level != 0L)?\
				 (level) & exp_verb_level:FALSE) 

#endif

/* PROTO exp.c */
/* exp.c */
void exp_debug_init P((void));
#endif
