/*
 * This file is a part of the gnetsentry project.
 * Copyright (C) 1998 Martin Gall
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*
 *
 */

#include "exp_scan.h"

/* SCAN ALGORITHM HERE IS QUITE SIMPLE, SHOULD IMPLEMENT ONE WITH
CONFLICT DETECTION, ETC... */

VOID_FUNC			scan_drv_sd_delete_free_data(delete_data,sd)
VOID_PTR			delete_data;
t_scan_drv			*sd;
{
  EXP_FREE_PROC(delete_data,"delete_data");
  EXP_FREE_PROC(sd,"sd");
}

VOID_FUNC			scan_drv_sd_delete(delete_data,sd)
VOID_PTR			delete_data;
t_scan_drv			*sd;
{
  EXP_FREE_PROC(sd,"sd");
}

t_scan				*scan_new(status)
t_status			*status;
{
  t_scan			*scan;

  if ((scan = EXP_ALLOC_PROC(sizeof (t_scan),"scan",status)) == NULL)
    return (NULL);
  if ((scan->drvs = EXP_VEC_NEW(status)) == NULL)
    {
      EXP_FREE_PROC(scan,"scan");
      return (NULL);
    }
  scan->text_len = 0;
  scan->text = NULL;
  scan->drv = NULL;
  scan->eob = FALSE;
  return (scan);
}

VOID_FUNC			scan_delete(scan)
t_scan				*scan;
{
  VEC_FOR(scan->drvs,t_scan_drv *sd)
    {
#ifdef NOTDEF
      scan_drv_show(sd);
#endif
      sd->delete(sd->delete_data,sd);
    }
  VEC_ENDFOR;
  vec_delete(scan->drvs);
  if (scan->text)
    EXP_FREE_PROC(scan->text,"scan->text");
  EXP_FREE_PROC(scan,"scan");
}

int				scan_add_drv(scan,drv)
t_scan				*scan;
t_scan_drv			*drv;
{
#ifdef NOTDEF
  scan_drv_show(drv);
#endif
  return (vec_add(scan->drvs,drv));
}

int				scan_compute_text_len(scan)
t_scan				*scan;
{
  int				text_len;

  text_len = 0;
  VEC_FOR(scan->drvs,t_scan_drv *drv)
    {
      text_len = MAX(text_len,drv->max_len);
    }
  VEC_ENDFOR;
  return (text_len);
}

t_status			scan_setup_text(scan,text_len)
t_scan				*scan;
int				text_len;
{
  t_status			status;

#ifdef DEBUG
  if (EXP_VERB(VERB_SCAN))
    fprintf(stderr,"text_len=%d\n",text_len);
#endif
  if (scan->text_len != text_len)
    {
      int			size;
      
      if (scan->text)
	EXP_FREE_PROC(scan->text,"scan->text");
      size = text_len * sizeof (char);
      if ((scan->text = EXP_ALLOC_PROC(size,"scan->text",&status)) == NULL)
	return (status);
      scan->text_len = text_len;
      scan->text[0] = 0;
    }
  return (0);
}

t_status			scan_setup(scan)
t_scan				*scan;
{
  return (scan_setup_text(scan,scan_compute_text_len(scan)));
}

VOID_FUNC			scan_set_buf(scan,buf,len)
t_scan				*scan;
char				*buf;
int				len;
{
  scan->buf = buf;
  scan->len = len;
  scan->pos = 0;
}

VOID_FUNC			scan_set_state(scan,state)
t_scan				*scan;
int				state;
{
  scan->state = state;
}

t_status			scan_next(scan,advice,val)
t_scan				*scan;
VOID_PTR			advice;
VOID_PTR			*val;
{
  int				i;
  t_scan_drv			*newdrv;
  t_status			status;
  
  assert(scan->text);
  i = scan->pos;
  while (i < scan->len)
    {
      int			current_len;

      if ((status = str_cat_char(scan->text,scan->text_len,scan->buf[i])) < 0)
	return (status);
      current_len = strlen(scan->text);
#ifdef DEBUG
      if (EXP_VERB(VERB_SCAN))
	scan_show_text(scan);
#endif
      if (scan->drv)
	{
	  if (current_len >= scan->drv->min_len && 
	      current_len <= scan->drv->max_len)
	    if (scan->drv->match(scan->drv->match_data,
				 scan->text,
				 current_len,
				 advice))
	      {
#ifdef DEBUG
		if (EXP_VERB(VERB_SCAN))
		  scan_show_drv(scan,scan->drv,"re");
#endif
		scan->pos++;
		i++;
		continue ;
	      }
	}
      newdrv = NULL;
      VEC_FOR(scan->drvs,t_scan_drv *sd)
	{
	  if (sd->state != scan->state || 
	      current_len < sd->min_len ||
	      current_len > sd->max_len)
	    continue ;
	  if (sd->match(sd->match_data,
			scan->text,
			current_len,
			advice))
	    {
	      newdrv = sd;
#ifdef DEBUG
	      if (EXP_VERB(VERB_SCAN))
		scan_show_drv(scan,sd,"found");
#endif
	      break ;
	    }
	}
      VEC_ENDFOR;
      if (newdrv)
	scan->drv = newdrv;
      else
	{
	  if (scan->drv)
	    {
	      int		status;

	      scan->text[strlen(scan->text) - 1] = 0;
	      if (scan->drv->cvt)
		{
#ifdef DEBUG
		  if (EXP_VERB(VERB_SCAN))
		    scan_show_drv(scan,scan->drv,"ok");
#endif
		  if ((status = 
		       scan->drv->cvt(scan->drv->cvt_data,
				      scan->text,
				      current_len - 1,
				      advice,
				      val)) < 0)
		    {
		      return (status);
		    }
		  scan->drv = NULL;
		  scan->text[0] = 0;
		  return (SCAN_TOK);
		}
	      else
		{
#ifdef DEBUG
		  if (EXP_VERB(VERB_SCAN))
		    scan_show_drv(scan,scan->drv,"ignored");
#endif
		  scan->drv = NULL;
		  scan->text[0] = 0;
		  continue ;
		}
	    }
	}
      scan->pos++;
      i++;
    }
  if (scan->eob)
    return (SCAN_EOB);
  else
    {
      scan->eob = TRUE;
      if (scan->drv)
	{
	  int		status;
	  int		textlen;
	  
	  textlen = strlen(scan->text);
	  scan->text[textlen] = 0;
	  if (scan->drv->cvt)
	    {
#ifdef DEBUG
	      if (EXP_VERB(VERB_SCAN))
		scan_show_drv(scan,scan->drv,"within eob: ok");
#endif
	      if ((status = 
		   scan->drv->cvt(scan->drv->cvt_data,
				  scan->text,
				  textlen,
				  advice,
				  val)) < 0)
		{
		  return (status);
		}
	      scan->text[0] = 0;
	      return (SCAN_TOK);
	    }
	  else
	    {
#ifdef DEBUG
	      if (EXP_VERB(VERB_SCAN))
		scan_show_drv(scan,scan->drv,"within eob: ignored");
#endif
	      scan->text[0] = 0;
	    }
	}
      return (SCAN_CONT);
    }
}

VOID_FUNC			scan_reset(scan)
t_scan				*scan;
{
#ifdef DEBUG
  if (EXP_VERB(VERB_SCAN))
    fprintf(stderr,"scan_reset\n");
#endif
  assert(scan->text);
  scan->drv = NULL;
  scan->text[0] = 0;
  scan->eob = FALSE;
}

#ifdef DEBUG
VOID_FUNC			scan_show_text(scan)
t_scan				*scan;
{
  char				buf[BUFSIZ];
  t_status			status;

  status = str_to_cstr(buf,sizeof (buf),scan->text);
  assert(status >= 0);  
  fprintf(stderr,"text=%s\n",buf);
}

VOID_FUNC			scan_show_drv(scan,sd,comment)
t_scan				*scan;
t_scan_drv			*sd;
char				*comment;
{
  fprintf(stderr,"%s\n",comment);
}

VOID_FUNC			scan_drv_show(sd)
t_scan_drv			*sd;
{
  fprintf(stderr,"sd->state=%d\n",sd->state);
  fprintf(stderr,"sd->min_len=%d\n",sd->min_len);
  fprintf(stderr,"sd->max_len=%d\n",sd->max_len);
  fprintf(stderr,"sd->match=%p\n",sd->match);
  fprintf(stderr,"sd->match_data=%p\n",sd->match_data);
  fprintf(stderr,"sd->cvt=%p\n",sd->cvt);
  fprintf(stderr,"sd->cvt_data=%p\n",sd->cvt_data);
  fprintf(stderr,"sd->delete=%p\n",sd->delete);
  fprintf(stderr,"sd->delete_data=%p\n",sd->delete_data);
}
#endif
