/*
 * This file is a part of the gnetsentry project.
 * Copyright (C) 1998 Martin Gall
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*
 *
 */

#include "exp_object.h"

t_object			*object_new(om,oid,status)
t_object_manager		*om;
int				oid;
t_status			*status;
{
  t_object			*o;

  if ((o = EXP_ALLOC_PROC(sizeof (t_object),"o",status)) == NULL)
    return (NULL);
  o->oid = oid;
  if (vec_add(om->objects,o) < 0)
    {
      EXP_FREE_PROC(o,"o");
      return (NULL);
    }
  return (o);
}

t_object_manager		*object_manager_new(compil,status)
t_compil			*compil;
t_status			*status;
{
  t_object_manager		*om;

  if ((om = EXP_ALLOC_PROC(sizeof (t_object_manager),
			   "om",
			   status)) == NULL)
    return (NULL);
  if ((om->oids = EXP_VEC_NEW(status)) == NULL)
    {
      EXP_FREE_PROC(om,"om");
      return (NULL);
    }
  if ((om->bops = EXP_DICT_NEW(status)) == NULL)
    {
      vec_delete(om->oids);
      EXP_FREE_PROC(om,"om");
      return (NULL);
    }
  if ((om->uops = EXP_DICT_NEW(status)) == NULL)
    {
      vec_delete(om->oids);
      dict_delete(om->bops);
      EXP_FREE_PROC(om,"om");
      return (NULL);
    }
  if ((om->objects = EXP_VEC_NEW(status)) == NULL)
    {
      vec_delete(om->oids);
      dict_delete(om->bops);
      dict_delete(om->uops);
      EXP_FREE_PROC(om,"om");
      return (NULL);
    }
  om->compil = compil;
  return (om);
}

int				object_manager_delete_vec_ombops(he,data)
t_hash_elt			*he;
VOID_PTR			data;
{
  t_vec				*vec;

  vec = (t_vec *)(he->value);
  vec_ptr_delete(vec);
  return (0);
}

int				object_manager_delete_vec_omuops(he,data)
t_hash_elt			*he;
VOID_PTR			data;
{
  t_vec				*vec;

  vec = (t_vec *)(he->value);
  vec_ptr_delete(vec);
  return (0);
}

VOID_FUNC			object_destroy(om,o)
t_object_manager		*om;
t_object			*o;
{
  t_object_def			*od;

  od = VEC_AT(om->oids,o->oid);
  od->delete(o);
}

VOID_FUNC			object_manager_destroy_objects(om)
t_object_manager		*om;
{
  VEC_FOR(om->objects,t_object *o)
    {
#ifdef NOTDEF
      fprintf(stderr,"destroying 0x%p (oid=%d)\n",o,o->oid);
#endif
      object_destroy(om,o);
    }
  VEC_ENDFOR;
  vec_ptr_destroy(om->objects);
}

VOID_FUNC			object_manager_delete(om)
t_object_manager		*om;
{
  dict_walk(om->bops,
	     (t_dict_walk_proc)object_manager_delete_vec_ombops,
	     NULL);
  dict_delete(om->bops);
  dict_walk(om->uops,
	     (t_dict_walk_proc)object_manager_delete_vec_omuops,
	     NULL);
  dict_delete(om->uops);
  vec_delete(om->objects);
  vec_delete(om->oids);
  EXP_FREE_PROC(om,"om");
}

int				object_manager_register(om,od)
t_object_manager		*om;
t_object_def			*od;
{
#ifdef DEBUG
  if (EXP_VERB(VERB_OBJ_INIT))
    fprintf(stderr,"registering `%s'\n",od->name);
#endif
  return (vec_add(om->oids,od));
}

t_boolean			object_manager_bop_sd_match(match_data,
							    text,
							    len,
							    advice)
char				*match_data;
char				*text;
int				len;
t_advice			*advice;
{
  if (advice->state != STATE_OPERATOR)
    return (FALSE);
  return (!strcmp(text,match_data));
}

int				object_manager_bop_do(ombop,
						      left,
						      right,
						      result)
t_object_manager_bop		*ombop;
t_object			*left;
t_object			*right;
VOID_PTR			*result;
{
  if (ombop->is_contr_proc)
    {
      t_boolean			ok;
      int			status;
      
      if ((status = ombop->is_contr_proc(ombop->data,
					 left,
					 &ok)) < 0)
	return (status);
      if (ok)
	return (ombop->contr_proc(ombop->data,left,result));
    }
  return (ombop->proc(ombop->data,left,right,result));
}

t_status			object_manager_bop_eval(data,
							left,
							right,
							result)
t_vec				*data;
t_object			*left;
t_object			*right;
VOID_PTR			*result;
{
  t_object_manager_bop		*left_all_ombop;
  t_object_manager_bop		*right_all_ombop;
  t_object_manager_bop		*both_all_ombop;

  left_all_ombop = right_all_ombop = both_all_ombop = NULL;
  VEC_FOR(data,t_object_manager_bop *ombop)
    {
#ifdef NOTDEF
      if (EXP_VERB(VERB_OBJ))
	fprintf(stderr,"loid=%d roid=%d l->oid=%d r->oid=%d\n",
		ombop->left_oid,ombop->right_oid,left->oid,right->oid);
#endif
      if (ombop->left_oid == left->oid &&
	  ombop->right_oid == right->oid)
	return (object_manager_bop_do(ombop,left,right,result));
      if (!right_all_ombop)
	if (ombop->left_oid == left->oid &&
	    ombop->right_oid == OBJECT_ID_ANY)
	  right_all_ombop = ombop;
      if (!left_all_ombop)
	if (ombop->right_oid == right->oid &&
	    ombop->left_oid == OBJECT_ID_ANY)
	  left_all_ombop = ombop;
      if (!both_all_ombop)
	if (ombop->left_oid == OBJECT_ID_ANY &&
	    ombop->right_oid == OBJECT_ID_ANY)
	  both_all_ombop = ombop;
    }
  VEC_ENDFOR;
  if (left_all_ombop)
    return (object_manager_bop_do(left_all_ombop,left,right,result));
  if (right_all_ombop)
    return (object_manager_bop_do(right_all_ombop,left,right,result));
  if (both_all_ombop)
    return (object_manager_bop_do(both_all_ombop,left,right,result));
  return (-ERR_NI);
}

t_status			object_manager_bop_sd_cvt(cvt_data,
							  text,
							  len,
							  advice,
							  token)
t_vec				*cvt_data;
char				*text;
int				len;
VOID_PTR			advice;
t_token				*token;
{
  t_object_manager_bop		*ombop;
  t_status			status;

  assert(VEC_COUNT(cvt_data) > 0);
  ombop = VEC_AT(cvt_data,0);
  token->token_type = TOKEN_BOP;
  token->token_bop_prio = ombop->prio;
  token->token_bop_assoc = ombop->assoc;
  token->token_bop_eval.is_contr_proc = NULL;
  token->token_bop_eval.contr_proc = NULL;
  token->token_bop_eval.proc = (t_eval_bop_proc)object_manager_bop_eval;
  token->token_bop_eval.data = (VOID_PTR)cvt_data;
  if (exp_keep_text)
    if ((token->token_show.text = strdup_alloc(text,
					       EXP_ALLOC_PROC,
					       "text",
					       &status)) == NULL)
      return (status);
  return (0);
}

VOID_FUNC			object_manager_bop_scan_drv_delete(scan_drv)
t_scan_drv			*scan_drv;
{
  EXP_FREE_PROC(scan_drv->match_data,"scan_drv->match_data");
  EXP_FREE_PROC(scan_drv,"scan_drv");
}

VOID_FUNC			object_manager_bop_sd_delete(delete_data,
							     sd)
VOID_PTR			delete_data;
t_scan_drv			*sd;
{
  object_manager_bop_scan_drv_delete(sd);
}

t_scan_drv			*object_manager_bop_scan_drv_new(str,
								 ombop,
								 vec,
								 status)
char				*str;
t_object_manager_bop		*ombop;
t_vec				*vec;
t_status			*status;
{
  t_scan_drv			*scan_drv;
  int				len;

  if ((scan_drv = EXP_ALLOC_PROC(sizeof (t_scan_drv),
				 "scan_drv",
				 status)) == NULL)
    return (NULL);
  len = strlen(str); 
  scan_drv->state = SCAN_STATE_DEFAULT;
  scan_drv->min_len = len;
  scan_drv->max_len = len;
  scan_drv->match = (t_scan_drv_match_proc)object_manager_bop_sd_match;
  if ((scan_drv->match_data = (VOID_PTR)strdup_alloc(str,
						     EXP_ALLOC_PROC,
						     "match_data",
						     status)) == NULL)
    {
      EXP_FREE_PROC(scan_drv,"scan_drv");
      return (NULL);
    }
  scan_drv->cvt = (t_scan_drv_cvt_proc)object_manager_bop_sd_cvt;
  scan_drv->cvt_data = (VOID_PTR)vec;
  scan_drv->delete = (t_scan_drv_delete_proc)object_manager_bop_sd_delete;
  return (scan_drv);
}

t_status			object_manager_request_bop(om,str,ombop)
t_object_manager		*om;
char				*str;
t_object_manager_bop		*ombop;
{
  t_hash_elt			*he;
  t_vec				*vec;	
  t_object_manager_bop		*nombop;
  t_status			status;

#ifdef DEBUG
  if (EXP_VERB(VERB_OBJ_INIT))
    object_manager_bop_show(str,ombop);
#endif
  if ((he = dict_get(om->bops,str)) == NULL)
    {
      t_scan_drv		*scan_drv;

      if ((vec = EXP_VEC_NEW(&status)) == NULL)
	return (status);
      if ((status = dict_add(om->bops,str,vec)) < 0)
	{
	  vec_delete(vec);
	  return (status);
	}
      if ((scan_drv = object_manager_bop_scan_drv_new(str,
						      ombop,
						      vec,
						      &status)) == NULL)
	return (status);
      if ((status = scan_add_drv(om->compil->scan,scan_drv)) < 0)
	{
	  object_manager_bop_scan_drv_delete(scan_drv);
	  return (status);
	}
    }
  else
    {
      t_object_manager_bop	*ref_ombop;

      vec = (t_vec *)(he->value);
      assert(VEC_COUNT(vec) > 0);
      ref_ombop = (t_object_manager_bop *)(VEC_AT(vec,0));
#ifdef DEBUG
      if (EXP_VERB(VERB_OBJ_INIT))
	object_manager_bop_show("ref_ombop",ref_ombop);
#endif
      if (ombop->prio != ref_ombop->prio ||
	  ombop->assoc != ref_ombop->assoc)
	return (-ERR_BADMATCH);
      if (ombop->left_oid == ref_ombop->left_oid &&
	  ombop->right_oid == ref_ombop->right_oid)
	return (-ERR_EXIST);
    }
  if ((nombop = EXP_ALLOC_PROC(sizeof (t_object_manager_bop),
			       "nombop",
			       &status)) == NULL)
    return (status);
  bcopy((char *)ombop,(char *)nombop,sizeof (t_object_manager_bop));
  if ((status = vec_add(vec,nombop)) < 0)
    {
      EXP_FREE_PROC(nombop,"nombop");
      return (status);
    }
  return (0);
}

t_boolean			object_manager_uop_sd_match(match_data,
							    text,
							    len,
							    advice)
char				*match_data;
char				*text;
int				len;
t_advice			*advice;
{
  if (advice->state == STATE_OPERATOR)
    return (FALSE);
  return (!strcmp(text,match_data));
}

t_status			object_manager_uop_eval(data,
							operand,
							result)
t_vec				*data;
t_object			*operand;
VOID_PTR			*result;
{
  VEC_FOR(data,t_object_manager_uop *omuop)
    {
      if (omuop->operand_oid == operand->oid)
	return (omuop->proc(omuop->data,operand,result));
    }
  VEC_ENDFOR;
  return (-ERR_NI);
}

t_status			object_manager_uop_sd_cvt(cvt_data,
							  text,
							  len,
							  advice,
							  token)
t_vec				*cvt_data;
char				*text;
int				len;
VOID_PTR			advice;
t_token				*token;
{
  t_object_manager_uop		*omuop;
  t_status			status;

  assert(VEC_COUNT(cvt_data) > 0);
  omuop = VEC_AT(cvt_data,0);
  token->token_type = TOKEN_UOP;
  token->token_uop_way = omuop->way;
  token->token_uop_eval.proc = (t_eval_uop_proc)object_manager_uop_eval;
  token->token_uop_eval.data = (VOID_PTR)cvt_data;
  if (exp_keep_text)
    if ((token->token_show.text = strdup_alloc(text,
					       EXP_ALLOC_PROC,
					       "text",
					       &status)) == NULL)
      return (status);
  return (0);
}

VOID_FUNC			object_manager_uop_scan_drv_delete(scan_drv)
t_scan_drv			*scan_drv;
{
  EXP_FREE_PROC(scan_drv->match_data,"scan_drv->match_data");
  EXP_FREE_PROC(scan_drv,"scan_drv");
}

VOID_FUNC			object_manager_uop_sd_delete(delete_data,
							     sd)
VOID_PTR			delete_data;
t_scan_drv			*sd;
{
  object_manager_uop_scan_drv_delete(sd);
}

t_scan_drv			*object_manager_uop_scan_drv_new(str,
								 omuop,
								 vec,
								 status)
char				*str;
t_object_manager_uop		*omuop;
t_vec				*vec;
t_status			*status;
{
  t_scan_drv			*scan_drv;
  int				len;

  if ((scan_drv = EXP_ALLOC_PROC(sizeof (t_scan_drv),
				 "scan_drv",
				 status)) == NULL)
    return (NULL);
  len = strlen(str); 
  scan_drv->state = SCAN_STATE_DEFAULT;
  scan_drv->min_len = len;
  scan_drv->max_len = len;
  scan_drv->match = (t_scan_drv_match_proc)object_manager_uop_sd_match;
  if ((scan_drv->match_data = (VOID_PTR)strdup_alloc(str,
						     EXP_ALLOC_PROC,
						     "match_data",
						     status)) == NULL)
    {
      EXP_FREE_PROC(scan_drv,"scan_drv");
      return (NULL);
    }
  scan_drv->cvt = (t_scan_drv_cvt_proc)object_manager_uop_sd_cvt;
  scan_drv->cvt_data = (VOID_PTR)vec;
  scan_drv->delete = (t_scan_drv_delete_proc)object_manager_uop_sd_delete;
  return (scan_drv);
}

t_status			object_manager_request_uop(om,str,omuop)
t_object_manager		*om;
char				*str;
t_object_manager_uop		*omuop;
{
  t_hash_elt			*he;
  t_vec				*vec;	
  t_object_manager_uop		*nomuop;
  t_status			status;

#ifdef DEBUG
  if (EXP_VERB(VERB_OBJ_INIT))
    object_manager_uop_show(str,omuop);
#endif
  if ((he = dict_get(om->uops,str)) == NULL)
    {
      t_scan_drv		*scan_drv;

      if ((vec = EXP_VEC_NEW(&status)) == NULL)
	return (status);
      if ((status = dict_add(om->uops,str,vec)) < 0)
	{
	  vec_delete(vec);
	  return (status);
	}
      if ((scan_drv = object_manager_uop_scan_drv_new(str,
						      omuop,
						      vec,
						      &status)) == NULL)
	return (status);
      if ((status = scan_add_drv(om->compil->scan,scan_drv)) < 0)
	{
	  object_manager_uop_scan_drv_delete(scan_drv);
	  return (status);
	}
    }
  else
    {
      t_object_manager_uop	*ref_omuop;

      vec = (t_vec *)(he->value);
      assert(VEC_COUNT(vec) > 0);
      ref_omuop = (t_object_manager_uop *)(VEC_AT(vec,0));
      if (omuop->way != ref_omuop->way)
	return (-ERR_BADMATCH);
      if (omuop->operand_oid == ref_omuop->operand_oid)
	return (-ERR_EXIST);
    }
  if ((nomuop = EXP_ALLOC_PROC(sizeof (t_object_manager_uop),
			       "nomuop",
			       &status)) == NULL)
    return (status);
  bcopy((char *)omuop,(char *)nomuop,sizeof (t_object_manager_uop));
  if ((status = vec_add(vec,nomuop)) < 0)
    {
      EXP_FREE_PROC(nomuop,"nomuop");
      return (status);
    }
  return (0);
}

VOID_FUNC			object_show(om,o)
t_object_manager		*om;
t_object			*o;
{
  t_object_def			*od;

  od = VEC_AT(om->oids,o->oid);
  od->show(o);
  printf("\n");
}

t_status			object_dup(om,src,dst)
t_object_manager		*om;
t_object			*src;
t_object			**dst;
{
  t_object_def			*od;
  t_status			status;

  if (((*dst) = object_new(om,src->oid,&status)) == NULL)
    return (status);
  od = VEC_AT(om->oids,src->oid);
  if ((status = od->dup(src,*dst)) < 0)
    {
      EXP_FREE_PROC(*dst,"*dst");
      return (status);
    }
  return (0);
}

int				object_id_get_from_name(om,name)
t_object_manager		*om;
char				*name;
{
  VEC_FOR(om->oids,t_object_def *od)
    {
      if (!strcmp(name,od->name))
	return (VEC_IDX);
    }
  VEC_ENDFOR;
  return (-ERR_NOENT);
}

#ifdef DEBUG
VOID_FUNC			object_manager_bop_show(str,ombop)
char				*str;
t_object_manager_bop		*ombop;
{
  fprintf(stderr,"`%s' left=%d right=%d prio=%d assoc=%d\n",
	  str,ombop->left_oid,ombop->right_oid,ombop->prio,ombop->assoc);
}

VOID_FUNC			object_manager_uop_show(str,omuop)
char				*str;
t_object_manager_uop		*omuop;
{
  fprintf(stderr,"`%s' operand=%d way=%d\n",
	  str,omuop->operand_oid,omuop->way);
}
#endif
