/*
 * This file is a part of the gnetsentry project.
 * Copyright (C) 1998 Martin Gall
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*
 *
 */

#include "exp_compil.h"
#include "exp_class_base.h"

t_status			eval_node_item(ni,result)
t_node_item			*ni;
VOID_PTR			*result;
{

#define OPERANDEVAL ni->token->token_operand_eval

  return (OPERANDEVAL.proc(OPERANDEVAL.data,ni->token,result));
}

int				eval_node_bop(nbop,result)
t_node_bop			*nbop;
VOID_PTR			*result;
{
  VOID_PTR			left_result;
  VOID_PTR			right_result;
  int				status;
  
#define BOPEVAL	nbop->bop->token->token_bop_eval

  if ((status = eval_node(nbop->left,&left_result)) < 0)
    return (status);
  if (BOPEVAL.is_contr_proc)
    {
      t_boolean			ok;
      
      if ((status = BOPEVAL.is_contr_proc(BOPEVAL.data,left_result,&ok)) < 0)
	return (status);
      if (ok)
	return (BOPEVAL.contr_proc(BOPEVAL.data,left_result,result));
    }
  if ((status = eval_node(nbop->right,&right_result)) < 0)
    return (status);
  return (BOPEVAL.proc(BOPEVAL.data,left_result,right_result,result));
}

int				eval_node_uop(nuop,result)
t_node_uop			*nuop;
VOID_PTR			*result;
{
  VOID_PTR			operand_result;
  int				status;

#define UOPEVAL nuop->uop->token->token_uop_eval

  if ((status = eval_node(nuop->operand,&operand_result)) < 0)
    return (status);
  return (UOPEVAL.proc(UOPEVAL.data,operand_result,result));
}

t_status			eval_node_func(nf,result)
t_node_func			*nf;
VOID_PTR			*result;
{
  t_eval_func_proc		proc;

#define FTOKEN nf->caller->token

  if (FTOKEN->token_operand_eval.proc != (t_eval_item_proc)object_ptrfunc_eval)
    return (-ERR_NOTAFUNC);
  proc = (t_eval_func_proc)(FTOKEN->token_operand_value);
  return (proc(FTOKEN,nf->params,result));
}

t_eval_proc			eval_procs[] =
{
  (t_eval_proc)eval_node_item,
  (t_eval_proc)eval_node_bop,
  (t_eval_proc)eval_node_uop,
  (t_eval_proc)eval_node_func
};

int				eval_node(node,result)
t_node				*node;
VOID_PTR			*result;
{
  assert(node->type < ARRAY_COUNT(eval_procs));
#ifdef DEBUG
  if (EXP_VERB(VERB_EVAL))
    node_show(node);
#endif
  return (eval_procs[node->type](node,result));
}

#ifdef DEBUG
char			*node_strs[] = 
{
  "item",
  "bop",
  "uop",
  "func"
};

VOID_FUNC		node_show(node)
t_node			*node;
{
  assert(node->type < ARRAY_COUNT(node_strs));
  fprintf(stderr,"%p: %s\n",node,node_strs[node->type]);
}
#endif
