/*
 * This file is a part of the gnetsentry project.
 * Copyright (C) 1998 Martin Gall
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*
 *
 */

#include "exp_class_str.h"

/*
 * scan
 */

/* PERMISSIVE */
t_boolean		cstr_match(str) 
char			*str;
{
  t_boolean		bslash;

  if (!(*str))
    return (FALSE);
  if (*str != '"')
    return (FALSE);
  str++;
  bslash = FALSE;
  while (*str)
    {
      if (bslash)
	{
	  bslash = FALSE;
	}
      else
	{
	  if (*str == '"')
	    {
	      if (*(str + 1))
		return (FALSE);
	      else
		return (TRUE);
	    }
	  if (*str == '\\')
	    bslash = TRUE;
	}
      str++;
    }
  return (FALSE);
}

t_status		str_from_cstr(str,max_len,cstr)
char			*str;
int			max_len;
char			*cstr;
{
  t_boolean		bslash;
  t_status		status;

  bslash = FALSE;
  str[0] = 0;
  cstr++;
  while (*(cstr + 1))
    {
      if (bslash)
	{
	  int		c;

	  if (*cstr == 'n')
	    c = '\n';
	  else
	    if (*cstr == 't')
	      c = '\t';
	    else
	      if (*cstr == 'r')
		c = '\r';
	      else
		c = *cstr;
	  if ((status = str_cat_char(str,max_len,c)) < 0)
	    return (status);
	  bslash = FALSE;
	  cstr++;
	  continue ;
	}
      if (*cstr == '\\')
	{
	  bslash = TRUE;
	  cstr++;
	  continue ;
	}
      if ((status = str_cat_char(str,max_len,*cstr)) < 0)
	return (-ERR_BO);
      cstr++;
    }
  if (bslash)
    return (-ERR_TRAILBSLASH);
  return (0);
}

t_status		str_to_cstr(cstr,max_len,str)
char			*cstr;
int			max_len;
char			*str;
{
  t_status		status;

  cstr[0] = 0;
  if ((status = str_cat_char(cstr,max_len,'"')) < 0)
    return (status);
  while (*str)
    {
      char		*backcode;

      backcode = NULL;
      if (*str == '\n')
	backcode = "\\n";
      else
	if (*str == '\r')
	  backcode = "\\r";
	else
	  if (*str == '\t')
	    backcode = "\\t";
	  else
	    if (*str == '"')
	      backcode = "\\\"";
      if (backcode)
	{
	  if ((status = str_cat_str(cstr,max_len,backcode)) < 0)
	    return (status);
	}
      else
	{
	  if ((status = str_cat_char(cstr,max_len,*str)) < 0)
	    return (status);
	}
      str++;
    }
  if ((status = str_cat_char(cstr,max_len,'"')) < 0)
    return (status);
  return (0);
}

/*
 * ops
 */

t_status		object_str_plus(data,left,right,result)
t_class_str_data	*data;
t_object		*left;
t_object		*right;
t_object		**result;
{
  size_t		size;
  char			*res;
  t_status		status;

  if (((*result) = object_new(data->om,data->oid,&status)) == NULL)
    return (status);
  size = strlen(left->value) + strlen(right->value) + 1;
  if ((res = EXP_ALLOC_PROC(size,"res",&status)) == NULL)
    {
      EXP_FREE_PROC(*result,"*result");
      return (status);
    }
  res[0] = 0;
  strcat(res,left->value);
  strcat(res,right->value);
  (*result)->value = res;
  return (0);
}

t_status		object_str_equal(data,left,right,result)
t_class_str_data	*data;
t_object		*left;
t_object		*right;
t_object		**result;
{
  t_status		status;

  if (((*result) = object_new(data->om,data->int_oid,&status)) == NULL)
    return (status);
  (*result)->value = (VOID_PTR)(!strcmp(left->value,right->value));
  return (0);
}

t_status		object_str_diff(data,left,right,result)
t_class_str_data	*data;
t_object		*left;
t_object		*right;
t_object		**result;
{
  t_status		status;

  if (((*result) = object_new(data->om,data->int_oid,&status)) == NULL)
    return (status);
  (*result)->value = (VOID_PTR)(strcmp(left->value,right->value));
  return (0);
}

t_object_str_bop_def		object_str_bop_defs[] = 
{
  {"+",		11,	BOP_LEFT,
   NULL,NULL,(t_eval_bop_proc)object_str_plus},
  {"==",	8,	BOP_LEFT,
   NULL,NULL,(t_eval_bop_proc)object_str_equal},
  {"!=",	8,	BOP_LEFT,
   NULL,NULL,(t_eval_bop_proc)object_str_diff},
};

/*
 * drivers
 */

t_boolean			object_str_sd_match(data,text,len,advice)
VOID_PTR			data;
char				*text;
int				len;
VOID_PTR			advice;
{
  return (cstr_match(text));
}

t_status			object_str_eval(data,token,result)
t_class_str_data		*data;
t_token				*token;
t_object			**result;
{
  t_object			*o;
  t_status			status;

  if ((o = object_new(data->om,data->oid,&status)) == NULL)
    return (status);
  if ((o->value = strdup_alloc(token->token_operand_value,
			       EXP_ALLOC_PROC,
			       "o->value",
			       &status)) == NULL)
    {
      EXP_FREE_PROC(o,"o");
      return (status);
    }
  (*result) = o;
  return (0);
}

t_status			object_str_sd_cvt(data,
						  text,
						  len,
						  advice,
						  token)
t_class_str_data		*data;
char				*text;
int				len;
VOID_PTR			advice;
t_token				*token;
{
  char				buf[BUFSIZ];
  t_status			status;
  char				*ntext;

  if (exp_keep_text)
    if ((ntext = strdup_alloc(text,
			      EXP_ALLOC_PROC,
			      "ntext",
			      &status)) == NULL)
      return (status);
  token->token_type = TOKEN_OPERAND;
  buf[0] = 0;
  if ((status = str_from_cstr(buf,sizeof (buf),text)) < 0)
    {
      if (exp_keep_text)
	EXP_FREE_PROC(ntext,"ntext");
      return (status);
    }
  if ((token->token_operand_value = strdup_alloc(buf,
						 EXP_ALLOC_PROC,
						 "token_operand_value",
						 &status)) == NULL)
    {
      if (exp_keep_text)
	EXP_FREE_PROC(ntext,"ntext");
      return (status);
    }
  if ((status = vec_add(data->pool,token->token_operand_value)) < 0)
    {
      if (exp_keep_text)
	EXP_FREE_PROC(ntext,"ntext");
      EXP_FREE_PROC(token->token_operand_value,
		    "token->token_operand_value");
      return (status);
    }
  token->token_operand_eval.proc = (t_eval_item_proc)object_str_eval;
  token->token_operand_eval.data = (VOID_PTR)data;
  if (exp_keep_text)
    token->token_show.text = ntext;
  return (0);
}

/*
 * class
 */

VOID_FUNC			object_str_show(o)
t_object			*o;
{
  char				buf[STR_BUFSIZ];
  int				status;

  buf[0] = 0;
  str_to_cstr(buf,sizeof (buf),o->value);
  printf("%s",buf);
}

VOID_FUNC			object_str_delete(o)
t_object			*o;
{
  EXP_FREE_PROC(o->value,"o->value");
}

t_status			object_str_dup(src,dst)
t_object			*src;
t_object			*dst;
{
  t_status			status;

  if ((dst->value = strdup_alloc(src->value,
				 EXP_ALLOC_PROC,
				 "value",
				 &status)) == NULL)
    return (status);
  return (0);
}

t_object_def			object_str_def =
{
  OBJECT_STR_STR,
  object_str_show,
  object_str_delete,
  object_str_dup
};

VOID_FUNC			object_str_sd_delete(delete_data,sd)
VOID_PTR			delete_data;
t_scan_drv			*sd;
{
  EXP_FREE_PROC(sd,"sd");
}

t_class_str_data		*class_str_data_new(status)
t_status			*status;
{
  t_class_str_data		*data;

  if ((data = EXP_ALLOC_PROC(sizeof (t_class_str_data),
			    "data",
			    status)) == NULL)
    return (NULL);
  if ((data->pool = EXP_VEC_NEW(status)) == NULL)
    {
      EXP_FREE_PROC(data,"data");
      return (NULL);
    }
  return (data);
}

VOID_FUNC			class_str_pool_destroy(data)
t_class_str_data		*data;
{
  vec_ptr_destroy(data->pool);
}

VOID_FUNC			class_str_pool_empty(data)
t_class_str_data		*data;
{
  vec_str_destroy(data->pool);
}

VOID_FUNC			class_str_tilde(data)
t_class_str_data		*data;
{
  vec_str_delete(data->pool);
  EXP_FREE_PROC(data,"data");
}

t_status			class_str(om,data)
t_object_manager		*om;
t_class_str_data		**data;
{
  int				oid;
  int				i;
  t_status			status;
  t_scan_drv			*scan_drv;
  int				int_oid;

  if ((int_oid = object_id_get_from_name(om,"int")) < 0)
    return (int_oid);
  if (((*data) = class_str_data_new(&status)) == NULL)
    return (status);
  if ((oid = object_manager_register(om,&object_str_def)) < 0)
    {
      EXP_FREE_PROC(*data,"*data");
      return (oid);
    }
  (*data)->om = om;
  (*data)->int_oid = int_oid;
  (*data)->oid = oid;
#ifdef DEBUG
  if (EXP_VERB(VERB_OBJ_INIT))
      fprintf(stderr,"object_str: oid=%d\n",oid);
#endif
  if ((scan_drv = EXP_ALLOC_PROC(sizeof (t_scan_drv),
				 "scan_drv",
				 &status)) == NULL)
    return (status);
  scan_drv->state = SCAN_STATE_DEFAULT;
  scan_drv->min_len = 1;
  scan_drv->max_len = STR_BUFSIZ;
  scan_drv->match = object_str_sd_match;
  scan_drv->match_data = NULL;
  scan_drv->cvt = (t_scan_drv_cvt_proc)object_str_sd_cvt;
  scan_drv->cvt_data = (VOID_PTR)(*data);
  scan_drv->delete = (t_scan_drv_delete_proc)object_str_sd_delete;
  if ((status = scan_add_drv(om->compil->scan,scan_drv)) < 0)
    return (status);
  i = 0;
  while (i < ARRAY_COUNT(object_str_bop_defs))
    {
      t_object_manager_bop	ombop;

      ombop.left_oid = oid;
      ombop.right_oid = oid;
      ombop.prio = object_str_bop_defs[i].prio;
      ombop.assoc = object_str_bop_defs[i].assoc;
      ombop.is_contr_proc = object_str_bop_defs[i].is_contr_proc;
      ombop.contr_proc = object_str_bop_defs[i].contr_proc;
      ombop.proc = object_str_bop_defs[i].proc;
      ombop.data = (VOID_PTR)(*data);
      if ((status = 
	   object_manager_request_bop(om,
				      object_str_bop_defs[i].pattern,
				      &ombop)) < 0)
	return (status);
      i++;
    }
  return (scan_setup_text(om->compil->scan,
			  scan_compute_text_len(om->compil->scan)));
}

t_class_def		class_str_def = 
{
  CLASS_STR_STR,
  (t_class_proc)class_str,
  (t_class_tilde_proc)class_str_tilde,
  (t_class_pool_destroy_proc)class_str_pool_destroy,
  (t_class_pool_empty_proc)class_str_pool_empty
};
