/*
 * This file is a part of the gnetsentry project.
 * Copyright (C) 1998 Martin Gall
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*
 *
 */

#ifndef A_MISC_H
#define A_MISC_H	1

#include "a.h"

#ifndef ABS
# define ABS(x)		(((x) < 0)?-(x):(x))
#endif

#define PTR_XY(ptr,width,posx,posy)	((ptr)[(posy) * (width) + (posx)])

typedef struct		s_assoc
{
  VOID_PTR		left;
  VOID_PTR		right;
} t_assoc;

#define STATUS(expr)	{int status; if ((status = (expr)) < 0) return status;}

#ifdef DEBUG
extern t_boolean	more_verbose;
#endif

typedef struct		s_buf
{
  char			*buf;
  int			len;
} t_buf;

typedef t_status	(*t_msg_proc) P((int msg,
					 VOID_PTR arg1,
					 VOID_PTR arg2));

#define RAND(n)		(rand() % (n))

/* PROTO a_misc.c */
/* a_misc.c */
int ipow P((int x, int n));
int ilog P((int x, int y));
t_status int_to_str P((int num, char *str, int max_len));
t_status uint_to_str P((unsigned int num, char *str, int max_len));
t_boolean atobooleanfalse P((char *str));
t_boolean atobooleantrue P((char *str));
void *pool_alloc P((t_vec *pool, t_alloc_proc alloc_proc, size_t size, char *comment, t_free_proc free_proc, t_status *status));
char *strdup_alloc P((char *str, t_alloc_proc alloc_proc, char *comment, t_status *status));
t_assoc *assoc_str_ptr_from_left P((t_assoc *assoc, char *left));
t_assoc *assoc_str_int_from_right P((t_assoc *assoc, int right));
t_boolean uint_match P((char *str));
char *str_skip P((char *str, char *chars));
char *str_find P((char *str, char *chars));
char *env_cache P((char *var, t_status *status));
void env_cache_delete P((void));
char *bindex P((char *buf, int len, int c));
int indexcount P((char *str, int c));
int xdigit_value P((int xdigit));
t_status xdata_to_buf P((char *xdata, char *buf, int *len, int max_len));
void a_debug_init P((void));
#endif
