/*
 * This file is a part of the gnetsentry project.
 * Copyright (C) 1998 Martin Gall
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*
 *
 */

#ifndef A_MATRIX_H
#define A_MATRIX_H	1

#include "a.h"

struct s_matrix;

typedef int		(*t_matrix_new_proc) P((struct s_matrix *matrix,
						int x,
						int y,
						unsigned int width,
						unsigned int height,
						VOID_PTR data));
typedef VOID_FUNC	(*t_matrix_delete_proc) P((struct s_matrix *matrix,
						   int x,
						   int y,
						   unsigned int width,
						   unsigned int height,
						   VOID_PTR data));

typedef struct			s_matrix
{
  t_boolean			dyn;
  unsigned int			width;
  unsigned int			height;
  VOID_PTR			*elts;
  t_alloc_proc			alloc_proc;
  t_free_proc			free_proc;
  t_matrix_new_proc		new_proc;
  t_matrix_delete_proc		delete_proc;	/* might be NULL	*/
  VOID_PTR			data;
} t_matrix;

#define MATRIX_NEW(w,h,statusp)	matrix_new((w),\
					   (h),\
					   FALSE,\
					   matrix_new_default,\
					   NULL,\
					   NULL,\
					   alloc_malloc,\
					   free_free,\
					   (statusp))

#define MATRIX_AT(matrix,posx,posy)	(PTR_XY((matrix)->elts,\
						(matrix)->width,\
						(posx),(posy)))

#define MATRIX_FOR(matrix,var)	{int _matrix_x,_matrix_y;\
    for(_matrix_y = 0;_matrix_y < (matrix)->height;_matrix_y++)\
	for(_matrix_x = 0;_matrix_x < (matrix)->width;_matrix_x++)\
      {var = MATRIX_AT((matrix),_matrix_x,_matrix_y);

#define MATRIX_COL_FOR(matrix,col,var) {int _matrix_x=(col);int _matrix_y;\
    for (_matrix_y = 0;_matrix_y < (matrix)->height;_matrix_y++)\
      {var = MATRIX_AT((matrix),_matrix_x,_matrix_y);

#define MATRIX_ROW_FOR(matrix,row,var) {int _matrix_x;int _matrix_y=(row)\
    for (_matrix_x = 0;_matrix_x < (matrix)->width;_matrix_x++)\
      {var = MATRIX_AT((matrix),_matrix_x,_matrix_y);

#define MATRIX_X		_matrix_x
#define MATRIX_Y		_matrix_y
#define MATRIX_ITEM(matrix)	MATRIX_AT((matrix),_matrix_x,_matrix_y)

#define MATRIX_ENDFOR		}}

#define MATRIX_WIDTH(matrix)	((matrix)->width)
#define MATRIX_HEIGHT(matrix)	((matrix)->height)

/* PROTO a_matrix.c */
/* a_matrix.c */
t_status matrix_new_default P((t_matrix *matrix, int x, int y, unsigned int width, unsigned int height, void *unused));
t_status matrix_alloc P((t_matrix *matrix));
t_matrix *matrix_new P((unsigned int width, unsigned int height, t_boolean dyn, t_matrix_new_proc new_proc, t_matrix_delete_proc delete_proc, void *data, t_alloc_proc alloc_proc, t_free_proc free_proc, t_status *status));
void matrix_destroy P((t_matrix *matrix));
void matrix_delete P((t_matrix *matrix));
t_status matrix_resize P((t_matrix *matrix, int nwidth, int nheight));
t_status matrix_add P((t_matrix *matrix, int x, int y, void *elt));
t_status matrix_dup P((t_matrix *src, t_matrix **dst));
#endif
