/*
 * This file is a part of the gnetsentry project.
 * Copyright (C) 1998 Martin Gall
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*
 *
 */

#ifndef A_HASH_H
#define A_HASH_H	1

#include "a.h"

#define HASH_BASE		1021		/* prev_prime_before(1024) */

typedef unsigned long		t_hash_code;

typedef struct			s_hash_elt
{
  VOID_PTR			key;
  VOID_PTR			value;
} t_hash_elt;

typedef int			(*t_hash_cmp_proc) P((VOID_PTR key1,
						      VOID_PTR key2));
typedef VOID_FUNC		(*t_hash_destroy_proc) P((t_hash_elt *he,
							  VOID_PTR data));

#define HASH_NEW(statusp)	hash_new(HASH_BASE,\
					 VEC_BASE,\
					 alloc_algorithm_power2,\
					 alloc_malloc,\
					 free_free,\
					 (statusp))

/* PROTO a_hash.c */
/* a_hash.c */
t_vec *hash_new P((int base, int list_base, t_alloc_algorithm_proc alloc_algorithm_proc, t_alloc_proc alloc_proc, t_free_proc free_proc, t_status *status));
void hash_destroy P((t_vec *ht, t_hash_destroy_proc destroy_proc, void *data));
void hash_delete P((t_vec *ht, t_hash_destroy_proc destroy_proc, void *data));
t_hash_elt *hash_elt_new P((t_vec *ht, t_status *status));
t_status hash_add P((t_vec *ht, t_hash_code hcode, void *key, void *value));
t_hash_elt *hash_get P((t_vec *ht, t_hash_code hcode, t_hash_cmp_proc cmp_proc, void *key));
t_status hash_rm P((t_vec *ht, t_hash_code hcode, t_hash_cmp_proc cmp_proc, void *key, t_hash_destroy_proc destroy_proc, void *data));
void hash_show_repartition P((t_vec *ht));
#endif
