/*
 * This file is a part of the gnetsentry project.
 * Copyright (C) 1998 Martin Gall
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*
 *
 */

#ifndef A_ERR_H
#define A_ERR_H	1

#include "a.h"

#define ERR_MAGICSYS		32768
#define ERR_SYS(status)		((status) > ERR_MAGICSYS)

#define ERR_UNDEFINED		1
#define ERR_EXIST		2
#define ERR_ALIGN		3
#define ERR_NOMEM		(ERR_MAGICSYS + 4)
#define ERR_NOENT		5
#define ERR_BO			6
#define ERR_BADFMT		7
#define ERR_READ		(ERR_MAGICSYS + 8)
#define ERR_INVAL		9
#define ERR_NOTDYN		10
#define ERR_SYNTAX		11
#define ERR_PAREN		12
#define ERR_NI			13
#define ERR_BADMATCH		14
#define ERR_BRACE		15
#define ERR_NOTDIGIT		16
#define ERR_TRAILBSLASH		17
#define ERR_NOTAFUNC		18
#define ERR_TRUNC		19
#define ERR_NOMETHOD		20
#define ERR_MALFORMED		21
#define ERR_UNRESOLVABLE	22
#define ERR_TOOMANY		23
#define ERR_NEEDMORE		24
#define ERR_CANTGOON		25
#define ERR_OPEN		(ERR_MAGICSYS + 26)
#define ERR_SYSCALL		(ERR_MAGICSYS + 27)
#define ERR_WRITE		(ERR_MAGICSYS + 28)
#define ERR_BADARGS		29
#define ERR_NEEDEQUAL		30
#define ERR_NEEDMOREDATA	31
#define ERR_NOSUCHVAR		32
#define ERR_TOOMUCHDATA		33
#define ERR_BADARGTYPE		34
#define ERR_NOSUCHFIELD		35
#define ERR_NOSUCHKEY		36
#define ERR_PARSE		37
#define ERR_DIVBYZERO		38

/* PROTO a_err.c */
/* a_err.c */
char *err_msg P((t_status errcode));
void err_print P((int errcode, char *fmt, ...));
#endif
