/*
 * This file is a part of the gnetsentry project.
 * Copyright (C) 1998 Martin Gall
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*
 *
 */

#include "a.h"

char		*vec_str_str_dup(vec,str,status)
t_vec		*vec;
char		*str;
t_status	*status;
{
  char		*new_str;
  
  if ((new_str = vec->alloc_proc(strlen(str) + 1,"new_str",status)) == NULL)
    return (NULL);
  strcpy(new_str,str);
  return (new_str);
}

t_status	vec_str_split(vec,s,sep)
t_vec		*vec;
char		*s;
int		sep;
{
  char		*p;
  char		*tmp;
  t_status	status;

  p = s;
  while (*p)
    {
      if (*p == sep)
	{
	  *p = 0;
	  if (tmp = vec_str_str_dup(vec,s,&status))
	    vec_add(vec,tmp);
	  else
	    return (status);
	  s = p + 1;
	}
      p++;
    } 
  if ((p - s) != 0)
    {
      if (tmp = vec_str_str_dup(vec,s,&status))
	{
	  if ((status = vec_add(vec,tmp)) < 0)
	    return (status);
	}
      else
	return (status);
    }
  return (0);
}

int		vec_str_index(vec,str)
t_vec		*vec;
char		*str;
{
  VEC_FOR(vec,char *s)
    {
      if (!strcmp(s,str))
	return (VEC_IDX);
    }
  VEC_ENDFOR;
  return (-ERR_NOENT);
}

char		*vec_str_to_str(vec,status)
t_vec		*vec;
t_status	*status;
{
  int		total_len;
  char		*s;
  int		size;
  int		offset;

  total_len = 0;
  VEC_FOR(vec,char *str)
    {
      total_len += strlen(str);
    }
  VEC_ENDFOR;
  size = (total_len + 1) * sizeof (char);
  if ((s = vec->alloc_proc(size,"s",status)) == NULL)
    return (NULL);
  offset = 0;
  VEC_FOR(vec,char *str)
    {
      strcpy(s + offset,str);
      offset += strlen(str); 
    }
  VEC_ENDFOR;
  s[offset] = 0;
  return (s);
}

t_status	vec_str_add(vec,str)
t_vec		*vec;
char		*str;
{
  char		*nstr;
  t_status	status;

  if ((nstr = vec_str_str_dup(vec,str,&status)) == NULL)
    return (status);
  if ((status = vec_add(vec,nstr)) < 0)
    vec->free_proc(nstr,"nstr");
  return (status);
}

VOID_FUNC	vec_str_destroy(vec)
t_vec		*vec;
{
  VEC_FOR(vec,char *str)
    {
      vec->free_proc(str,"str");
    }
  VEC_ENDFOR;
  vec_destroy(vec);
}

VOID_FUNC	vec_str_delete(vec)
t_vec		*vec;
{
  vec_str_destroy(vec);
  vec_delete(vec);
}

#ifdef DEBUG
VOID_FUNC	vec_str_show(vec)
t_vec		*vec;
{
  VEC_FOR(vec,char *str)
    {
      if (str)
	fprintf(stderr,"`%s'",str);
      else
	fprintf(stderr,"(null)");
      fprintf(stderr," ");
    }
  VEC_ENDFOR;
  fprintf(stderr,"\n");
}
#endif
