/*
 * This file is a part of the gnetsentry project.
 * Copyright (C) 1998 Martin Gall
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*
 *
 */

#include "a.h"

#ifndef HAVE_STRDUP
char			*strdup(s)
char			*s;
{
  char			*new;
  
  if ((new = MALLOC((strlen(s) + 1) * sizeof (char),"new")) == NULL)
    return (NULL);
  strcpy(new,s);
  return (new);
}
#endif

#ifndef HAVE_USLEEP
int			usleep(us)
int			us;
{
   struct timeval	tv;

   tv.tv_sec = us / 1000000;
   tv.tv_usec = us % 1000000;
   return (select(0,NULL,NULL,NULL,&tv));
}
#endif

#ifndef HAVE_STRERROR
char			*strerror(errcode)
int			errcode;
{
  return (sys_errlist[errcode]);
}
#endif

#ifndef HAVE_SETSERVENT
int			setservent(stay_open)
int			stay_open;
{
  return (0);
}
#endif

#ifndef HAVE_SETPROTOENT
int			setprotoent(stay_open)
int			stay_open;
{
  return (0);
}
#endif
