/*
 * This file is a part of the gnetsentry project.
 * Copyright (C) 1998 Martin Gall
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*
 *
 */

#include "a.h"

t_mask_def		*mask_get_def_from_str(defs,str)
t_mask_def		*defs;
char			*str;
{
  while (defs->str)
    {
      if (!strcmp(defs->str,str))
	return (defs);
      defs++;
    }
  return (NULL);
}

t_mask_def		*mask_get_def_from_mask(defs,mask)
t_mask_def		*defs;
t_mask			mask;
{
  while (defs->str)
    {
      if (mask == defs->mask)
	return (defs);
      defs++;
    }
  return (NULL);
}

t_status		mask_from_vec_str(defs,vec_str,mask)
t_mask_def		*defs;
t_vec			*vec_str;
t_mask			*mask;
{
  if (VEC_COUNT(vec_str) > 0)
    {
      VEC_FOR(vec_str,char *str)
	{
	  t_mask_def	*mask_def;
	  
	  if (mask_def = mask_get_def_from_str(defs,str))
	    {
	      if (mask_def->mask == 0)
		(*mask) = 0;
	      else
		(*mask) |= mask_def->mask;
	    }
	  else
	    return (-ERR_NOENT);
	}
      VEC_ENDFOR;
    }
  return (0);
}

t_status		mask_to_str(defs,mask,sep,str,max_len)
t_mask_def		*defs;
t_mask			mask;
char			*sep;
char			*str;
int			max_len;
{
  t_boolean		found;
  t_status		status;

  found = FALSE;
  while (defs->str)
    {
      if (((mask & defs->mask) == defs->mask) && (defs->mask != 0))
	{
	  if (found)
	    {
	      if ((status = str_cat_str(str,max_len,sep)) < 0)
		return (status);
	      found = FALSE;
	    }
	  if ((status = str_cat_str(str,max_len,defs->str)) < 0)
	    return (status);
	  found = TRUE;
	}
      defs++;
    }
  return (0);
}
