#! /bin/sh

tf=/tmp/copyright.$$

if [ "$#" -ne 1 ]
then
    echo usage: copyright.sh file.[ch]
    exit 1
fi
if [ ! -f $1 ]
then
    echo no such file $1
    exit 1
fi
cat > $tf <<EOF
/*
 * This file is a part of the gnetsentry project.
 * Copyright (C) 1998 Martin Gall
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
EOF
cat $1 >> $tf
cp $tf $1
rm -f $tf
exit 0
