/*
 *  util.h -- Gate util header
 *
 *  ORIGINAL AUTHOR: Stas Lanford (stas@netsis.com)
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License
 *  as published by the Free Software Foundation; either version 2
 *  of the License, or (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */




#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <sys/types.h>
#include <sys/stat.h>



#define MAIN_LOG	"gate.log"
#define RD_ONLY		"400" /* Owner/read only file mode */

#define AGREETITLE      "Agreement Statement"
#define AGREESTATE	"Do you agree to the conditions listed in the License?"
#define AFILE           ".agate"        /* hidden */
#define L_FILE		"LICENSE"	/* license file */
#define ERR_DELAY       2       /* time to sleep */




char check_result[]; /* wtf is this? */

/* 
 * Core prototypes 
 */

void mmenu (const char *t, int ac, const char * const * av); 
char *gettime(void); 
char ** parsemain (char *input);
void quit(char **array);
void writehead(void);
void errmsg(char *msg);
short init_mmenu(char **args);
int askargs (char *title, char *prompt);
int fcheck(char *file);
int agree(void);
FILE *openlog(void);

 
