/*
 *  ipscan.c -- Gate network code
 *
 *  ORIGINAL AUTHOR: Stas Lanford (stas@netsis.com)
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License
 *  as published by the Free Software Foundation; either version 2
 *  of the License, or (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */



#include "net.h"
#include "interface.h"
#include "util.h"


void scan(char **iprange);



void ipscan(char **iprange) {

	scan(iprange);
	dialog_clear();
        dialog_textbox(IP_SCANRES, MAIN_LOG, 20, 60);
}
	
void scan(char **iprange)

{

u_long addr;
unsigned int index;
FILE *log;


	log = openlog();
	for (index=0; iprange[index]!=NULL; index++) {
			struct hostent *he;
			(int)addr = inet_addr(iprange[index]);
			if ((he = gethostbyaddr((char *)&addr, sizeof(addr), AF_INET))
				== NULL) {
				fprintf(log, "%s -----> NULL\n", iprange[index]);
			}
			else {
				fprintf(log, "%s -----> %s\n", iprange[index], he->h_name);
			}
		}
	/* DONE */
	fclose(log);

}


	
