#include "net.h"


int get_connection(int socket_type, u_short port, int *listener)
{
  struct sockaddr_in address;
  int listening_socket;
  int connected_socket = -1;
  int new_process;
  int reuse_addr = 1;

  /* Setup internet address information.  
     This is used with the bind() call */
  memset((char *) &address, 0, sizeof(address));
  address.sin_family = AF_INET;
  address.sin_port = port;
  address.sin_addr.s_addr = htonl(INADDR_ANY);

  listening_socket = socket(AF_INET, socket_type, 0);
  if (listening_socket < 0) {
    perror("socket");
    exit(EXIT_FAILURE);
  }

  if (listener != NULL)
    *listener = listening_socket;

  setsockopt(listening_socket, SOL_SOCKET, SO_REUSEADDR, &reuse_addr, 
    sizeof(reuse_addr));

  if (bind(listening_socket, (struct sockaddr *) &address, 
    sizeof(address)) < 0) {
    perror("bind");
    close(listening_socket);
    exit(EXIT_FAILURE);
  }

  if (socket_type == SOCK_STREAM) {
    listen(listening_socket, 5); /* Queue up to five connections before
                                  having them automatically rejected. */

    while(connected_socket < 0) {
      connected_socket = accept(listening_socket, NULL, NULL);
      if (connected_socket < 0) {
        /* Either a real error occured, or blocking was interrupted for
           some reason.  Only abort execution if a real error occured. */
        if (errno != EINTR) {
          perror("accept");
          close(listening_socket);
          exit(EXIT_FAILURE);
        } else {
          continue;    /* don't fork - do the accept again */
        }
      }

      new_process = fork();
      if (new_process < 0) {
        perror("fork");
        close(connected_socket);
        connected_socket = -1;
      }
      else { /* We have a new process... */
        if (new_process == 0) {
          /* This is the new process. */
          close(listening_socket); /* Close our copy of this socket */
	  if (listener != NULL)
	          *listener = -1; /* Closed in this process.  We are not 
				     responsible for it. */
        }
        else {
          /* This is the main loop.  Close copy of connected socket, and
             continue loop. */
          close(connected_socket);
          connected_socket = -1;
        }
      }
    }
    return connected_socket;
  }
  else
    return listening_socket;
}


int set_connection(char *host, unsigned int port, int sock) {

	struct sockaddr_in *te;
	int ret;

	te = malloc(1*sizeof(struct sockaddr_in));
	memset((char *)te, 0, sizeof(struct sockaddr_in));
	

	te->sin_port = htons(port);
	te->sin_family = AF_INET;
	te->sin_addr.s_addr  = inet_addr(host);

	ret = connect(sock, (struct sockaddr_in *)te, sizeof(struct sockaddr_in));
	free(te);
	return ret;
}



int set_connect(char *host, int port, int *sockfd) {

        struct sockaddr_in addr;

        memset((char *)&addr, 0, sizeof(addr));
        addr.sin_family = AF_INET;
        addr.sin_port = htons(port);
        addr.sin_addr.s_addr = inet_addr(host);

        if ((*sockfd = socket(AF_INET, SOCK_STREAM, 0)) <= 0) {
                exit(1);
        }
        return connect(*sockfd, (struct sockaddr *)&addr, sizeof(addr)); 
}


int f_connect(char *host, int *sockfd) {

        struct sockaddr_in addr;

        memset((char *)&addr, 0, sizeof(addr));
        addr.sin_family = AF_INET;
        addr.sin_port = htons(79);
        addr.sin_addr.s_addr = inet_addr(host);

        if ((*sockfd = socket(AF_INET, SOCK_STREAM, 0)) <= 0) {
                exit(1);
        }
        return connect(*sockfd, (struct sockaddr *)&addr, sizeof(addr)); 
}



int sock_read(int sockfd, char *buf, size_t count)
{
	size_t bytes_read = 0;
	int this_read;

	while (bytes_read < count) {
		do {
			this_read = read(sockfd, buf, count - bytes_read);
		}
		while ( (this_read < 0) && (errno == EINTR) );
			if (this_read < 0)
			return this_read;
			else if (this_read == 0)
				return bytes_read;
			bytes_read += this_read;
			buf += this_read;
		}
	return count;
}



int sock_write(int sockfd, char *buf, size_t count)
{
	size_t bytes_sent = 0;
	int this_write;

	while (bytes_sent < count) {
		do
			this_write = write(sockfd, buf, count - bytes_sent);
			while ( (this_write < 0) && (errno == EINTR) );
				if (this_write <= 0)
			return this_write;
		bytes_sent += this_write;
		buf += this_write;
	}
	return count;
}


int sock_gets(int sockfd, char *str, size_t count)
{
	int bytes_read;
	int total_count = 0;
	char *current_position;
	char last_read = 0;

	current_position = str;
	while (last_read != 10) {
		bytes_read = read(sockfd, &last_read, 1);
		if (bytes_read <= 0) {
			return -1; 
		}
		if ( (total_count < count) && (last_read != 10) && (last_read !=13) ) {
		      current_position[0] = last_read;
		      current_position++;
		      total_count++;
		}
	}
	if (count > 0)
		current_position[0] = 0;
	return total_count;
}



int sock_puts(int sockfd, char *str)
{
	return sock_write(sockfd, str, strlen(str));
}


char *hostname(void) {

	char hostname[100];
	
	if (gethostname((char *)&hostname, sizeof(hostname)) <0) {
		fprintf(stderr, "Unable to get local hostname.");
	} else { 	
		return hostname;
	}
}
