#include <config.h>
#include "basic.h"
#include "n_errno.h"
#include "n_string.h"

/* Shitty libraries forgot strcasecmp ...
 * Here is the basic version I made for GEMA */

#ifndef HAVE_STRCASECMP
int strcasecmp(const char *s1, const char *s2)
{
   register const unsigned char *p1 = (const unsigned char *) s1;
   register const unsigned char *p2 = (const unsigned char *) s2;
   unsigned char c1, c2;

   if (p1 == p2)
      return 0;
   do {
      c1 = tolower(*p1++);
      c2 = tolower(*p2++);
      if (c1 == '\0')
        break;
   } while (c1 == c2);

   return c1 - c2;
}
#endif

/* Just like the previous one with a fixed length */

#ifndef HAVE_STRNCASECMP
int strncasecmp(const char *s1, const char *s2, size_t n)
{
   register const unsigned char *p1 = (const unsigned char *) s1;
   register const unsigned char *p2 = (const unsigned char *) s2;
   unsigned char c1, c2;

   if (p1 == p2 || n == 0)
      return 0;
   do
   {
      c1 = tolower(*p1++);
      c2 = tolower(*p2++);
      if (c1 == '\0' || c1 != c2)
        return c1 - c2;
   } while (--n > 0);

   return c1 - c2;
}
#endif

/* Yet another handy function taken from GEMA :
 * compare the beginning of a string with a token. The token of the string
 * itself case be in any case, but the token has to be in lower case. */

int strtokcasecmp(const char *s, const char *token)
{
   register const unsigned char *p1 = (const unsigned char *) s;
   register const unsigned char *p2 = (const unsigned char *) token;
   unsigned char c1, c2;

   if (p1 == p2)
      return 0;
   for (;;)
   {
      if ((c2 = *p2) == 0)
         return 0;
      p2++;
      if ((c1 = tolower(*p1)) == 0 || c1 != c2)
         return -1;
      p1++;
   }
}

/* A faster strcasecmp() as s2 has to be in lower case */ 

int strfastcasecmp(const char *s1, const char *s2)
{
   register const unsigned char *p1 = (const unsigned char *) s1;
   register const unsigned char *p2 = (const unsigned char *) s2;
   unsigned char c1, c2;

   if (p1 == p2)
      return 0;
   do {
      c1 = tolower(*p1++);
      c2 = *p2++;
      if (c1 == '\0')
        break;
   } while (c1 == c2);

   return c1 - c2;
}


/* Some systems have a broken fgets(), so here is our implementation */

char *str_fgets(char * const buf, size_t len, FILE * const fp)
{
   unsigned char *cp = (unsigned char *) buf;
   int c;       
   
   while (len > 1 && (c = getc(fp)) != EOF) {
      len--;
      *cp++ = c;
      if (c == '\n') {
	break;
      }
   }       
   if (cp != (unsigned char *) buf) {
      *cp = 0;
      return buf;
   } 
   return NULL;
}

/* fgets() that does not include a trailing '\n' in the result */

char *str_fgetsn(char * const buf, size_t len, FILE * const fp)
{
   unsigned char *cp = (unsigned char *) buf;
   int c;
   
   while (len > 1 && (c = getc(fp)) != EOF) {
      len--;
      if (c == '\n') {
	 *cp++ = 0; 
	 break;
      }
      *cp++ = c;                              
   }
   if (cp != (unsigned char *) buf) {
      *cp = 0;
      return buf;
   }
   return NULL;              
}

/* Several libc use strtok in their private system calls, kludging
 * the static pointer */

char *str_strtok(char *buf, const char *sep)
{
   static char *state;
   char *result;
   
   if (buf != NULL) {
     state = buf;    
   }
   if (*(state += strspn(state, sep)) == 0) {
     return NULL;
   }
   result = state;
   if (*(state += strcspn(state, sep)) != 0) {
     *state++ = 0;
   }
   
   return result;
}

/* Get the next token of a string, using spaces as delimiters.
 * Double-quotes are recognized in order to include spaces
 * in resulting strings */

char *str_strtokspace(char *buf)
{
   static char *state;
   char *result;
   int quote = 0;
   
   if (buf != NULL) {
      state = buf;
   }
   for (;;) {
      if (*state == 0) {
	 return NULL;
      } else if (*state == '"') {
	 quote = 1;
      } else if (!isspace(*state)) {
	 break;
      }
      state++;
   }
   result = state;
   if (quote == 0) {
      while (*state != 0 && !isspace(*state)) {
	 state++;
      }
   } else {
      while (*state != 0 && *state != '"') {
	 state++;
      }
   }
   *state++ = 0;
   
   return result;
}

/* Some systems don't know about strdup() */

#ifndef HAVE_STRDUP

char *strdup(const char *str)
{
   char *str2;
   size_t s;   
   
   if (str == NULL) {
      return NULL;
   }
   s = strlen(str) + 1;
   if ((str2 = (char *) malloc(s)) != NULL) {
      memcpy(str2, str, s);
   }
   return str2;
}

#endif

