#include <config.h>
#include "basic.h"
#include <signal.h>

/* Run callback when a sig signal is received */

int signal_catch(const int sig, RETSIGTYPE (*callback)(int))
{
#if defined (HAVE_SIGACTION) || defined (__SYSV__) || defined (SYSV) || defined (__SVR4)
   struct sigaction sa;
   
   sa.sa_handler = callback;
   sa.sa_flags = 0;
   sigemptyset(&sa.sa_mask);
   sigaction(sig, &sa, NULL);
#else
   signal(sig, callback); 
#endif                          
   return 0;
}

/* Block a signal */

int signal_block(const int sig)
{
#if defined (HAVE_SIGPROCMASK) || defined (__SYSV__) || defined (SYSV) || defined (__SVR4)
   sigset_t ss;
   
   sigemptyset(&ss);
   sigaddset(&ss, sig);
   sigprocmask(SIG_BLOCK, &ss, NULL);
#else
   sigblock(1 << (sig - 1));
#endif
   return 0;
}

/* Unblock a signal */

int signal_unblock(const int sig)
{
#if defined (HAVE_SIGPROCMASK) || defined (__SYSV__) || defined (SYSV) || defined (__SVR4)
   sigset_t ss;
   
   sigemptyset(&ss);
   sigaddset(&ss, sig);
   sigprocmask(SIG_UNBLOCK, &ss, NULL);
#else
   sigsetmask(sigsetmask(~0) & ~(1 << (sig - 1)));
#endif
   return 0;
}

