
/* (C)oderite Jedi/Sector One */

#include <config.h>
#include "basic.h"
#include "n_errno.h"

extern int errno;

void tracerr(const char * const file, const int line
#ifdef HAVE_PRETTY_FUNCTION
	     , const char * const function
#endif
	     )
{
#ifdef DEBUG
# ifdef HAVE_PRETTY_FUNCTION   
   fprintf(stderr, "** Source file: [%s], Function: [%s], Line: [%d]\n",
	   file, function, line);
# else
   fprintf(stderr, "** Source file: [%s], Line: [%d]\n", file, line);     
# endif   
#else
   (void) file; (void) line;
# ifdef HAVE_PRETTY_FUNCTION
   (void) function;
# endif
#endif
}

void printerr(const char * const more,
	      const char * const file, const int line
#ifdef HAVE_PRETTY_FUNCTION
	      , const char * const function
#endif
	      )
{
#ifdef DEBUG
   if (errno == 0) {
      fputs(more, stderr);
      fputs("\n", stderr);
   } else {
      perror(more);
   }
   tracerr(file, line
#ifdef HAVE_PRETTY_FUNCTION
	 , function
#endif
	 );
#else
   (void) more; (void) file; (void) line;
# ifdef HAVE_PRETTY_FUNCTION
   (void) function;
# endif   
#endif
}

const char *newstrerror(const int err)
{
   if (err == 0) {
      return "";
   }
#ifdef HAVE_STRERROR
   return strerror(err);
#else
   return sys_errlist[err];
#endif
}
