#ifndef INCLUDED_PARSER
#define INCLUDED_PARSER

#include "n_regex.h"

typedef struct Port_ {
   char *name;
   int port;
} Port;

typedef struct ServiceContext_ {
   char *description;                    /* DESCRIPTION */
   char *hostname;                       /* HOST */
   Port servicename;                     /* SERVICE */
   long int corelimit;                   /* CORELIMIT */
   const char *proto;                    /* PROTO */
   const char *endpoint;                 /* ENDPOINT */
   unsigned char wait;                   /* WAIT (255=N/A 1=nowait 0=wait) */
   long session_timelimit;               /* SESSION_TIMELIMIT */
   int session_cpuplimit;                /* SESSION_CPUPLIMIT xx% */
   long session_cpulimit;                /* SESSION_CPULIMIT <time> */
   long session_filelimit;               /* SESSION_FILELIMIT */
   long session_datalimit;               /* SESSION_DATALIMIT */
   long session_stacklimit;              /* SESSION_STACKLIMIT */
   int session_fdlimit;                  /* SESSION_FDLIMIT */
   int service_cpuplimit;                /* SERVICE_CPUPLIMIT xx% */
   long service_cpulimit;                /* SERVICE_CPULIMIT <time> */
   unsigned int service_nblimit;         /* SERVICE_NBLIMIT */
   unsigned int service_cur_nblimit;
   time_t cnx_timeout;                   /* CNX_TIMEOUT */
   time_t abuse_detect_time;             /* ABUSE_DETECT_TIME */
   unsigned int abuse_detect_sameservice;/* ABUSE_DETECT_SAMESERVICE */   
   unsigned int abuse_detect_samehost;   /* ABUSE_SAMEHOST */
   unsigned int abuse_detect_samenet;    /* ABUSE_SAMENET */
   time_t abuse_denytime;                /* ABUSE_DENYTIME */
   char **abuse_denyservices;            /* ABUSE_DENYSERVICES */
   char **abuse_run;                     /* ABUSE_RUN */
   char *abuse_logfile;                  /* ABUSE_LOGFILE */
   regex_t *rx_allow;                    /* ALLOW */
   regex_t *rx_allow_except;             /* ALLOW_EXCEPT */
   regex_t *rx_deny;                     /* DENY */
   regex_t *rx_deny_except;              /* DENY_EXCEPT */
   regex_t *rx_allow_ip;                 /* ALLOW_IP */
   regex_t *rx_allow_ip_except;          /* ALLOW_IP_EXCEPT */
   regex_t *rx_deny_ip;                  /* DENY_IP */
   regex_t *rx_deny_ip_except;           /* DENY_IP_EXCEPT */   
   char *user;                           /* USER */
   char *group;                          /* GROUP */
   char *chroot;                         /* CHROOT */
   char *logfile;                        /* LOGFILE */
   char **run;                           /* RUN */
   char **env;                           /* ENV */
   char **filter;                        /* FILTER */
   char *gateway_to_host;                /* GATEWAY_TO <xx> .. */
   Port gateway_to_port;                 /* GATEWAY_TO .. <xx> */
   char *gateway_from;                   /* GATEWAY_FROM */
   unsigned int spawn_nblimit;           /* SPAWN_NBLIMIT */
   int spawn_cpuplimit;                  /* SPAWN_CPUPLIMIT xx% */
   time_t spawn_cpulimit;                /* SPAWN_CPULIMIT <time> */
   int spamfilter;                       /* SPAMFILTER */
   
   Builtin builtin;
   
   char hasaction;            
   ServiceNetworkStatus servicenetworkstatus;
   
   struct ServiceContext_ *next;
} ServiceContext;

typedef struct ParserContext_ {
   ServiceContext *currentservicecontext;
   unsigned int depth;
} ParserContext;

typedef struct ParserResult_ {
   ServiceContext *firstservicecontext;
   int error;
} ParserResult;

enum {
   PARSER_MAXDEPTH = 64,
   PARSER_MAXRUNARGS = 256
};

enum {
   PARSER_COMMENT = '#',
   PARSER_STARTBLOCK = '{',
   PARSER_ENDBLOCK = '}',
   PARSER_SERVICEEQUIV = '=',
   PARSER_DIRECTORYSEP = '/'
#define PARSER_DIRECTORYSEP_STR "/"
};

#define PARSER_DEFAULTPROTOCOL "tcp"
#define PARSER_DEFAULTENDPOINT "stream"

ParserResult parser_parseconfigfile(const char *file);

typedef struct Lotus_ {
   const char * const token;
   int (*fct)(ParserContext *parsercontext);
} Lotus;

#ifdef DEFINE_PARSER_GLOBALS

typedef struct ParserBuiltins_ {
   const char * const keyword;
   const Builtin builtin;   
} ParserBuiltins;

#define BI(X) { #X , BUILTIN_ ## X }

const ParserBuiltins parserbuiltins[] = {
   BI(ECHO), BI(DISCARD), BI(INFO), 
   BI(GATEWAY)
};   

# define PIF(X) parser_item_ ## X
# define TI(X) { #X , PIF(X) }
# define PRO(X) static int PIF(X)(ParserContext *parsercontext)
# define GETNEXTOKEN ((item = str_strtokspace(NULL)) != NULL)

PRO(CORELIMIT); PRO(SERVICE); PRO(RUN); PRO(BUILTIN);
PRO(GATEWAY_TO); PRO(PROTO); PRO(GATEWAY_FROM); PRO(HOST);
PRO(DESCRIPTION); PRO(USER); PRO(GROUP); PRO(CHROOT);
PRO(ALLOW); PRO(ALLOW_EXCEPT); PRO(DENY); PRO(DENY_EXCEPT);
PRO(ALLOW_IP); PRO(ALLOW_IP_EXCEPT); PRO(DENY_IP); PRO(DENY_IP_EXCEPT);
PRO(SERVICE_NBLIMIT); PRO(SESSION_CPULIMIT); PRO(SESSION_FILELIMIT);
PRO(SESSION_DATALIMIT); PRO(SESSION_STACKLIMIT); PRO(SESSION_FDLIMIT);
PRO(SPAMFILTER); PRO(SESSION_TIMELIMIT);

static Lotus tokenindex[] = {
   TI(CORELIMIT), TI(SERVICE), TI(RUN), TI(BUILTIN), 
   TI(GATEWAY_TO), TI(PROTO), TI(GATEWAY_FROM), TI(HOST),
   TI(DESCRIPTION), TI(USER), TI(GROUP), TI(CHROOT),
   TI(ALLOW), TI(ALLOW_EXCEPT), TI(DENY), TI(DENY_EXCEPT),
   TI(ALLOW_IP), TI(ALLOW_IP_EXCEPT), TI(DENY_IP), TI(DENY_IP_EXCEPT),
   TI(SERVICE_NBLIMIT), TI(SESSION_CPULIMIT), TI(SESSION_FILELIMIT),
   TI(SESSION_DATALIMIT), TI(SESSION_STACKLIMIT), TI(SESSION_FDLIMIT),
   TI(SPAMFILTER), TI(SESSION_TIMELIMIT)
};
#endif
   
#endif
