#! /usr/local/bin/perl
# This little Perl 5 script will help you to convert an inetd.conf file
# into a jnetd.cf file for G2S. -Jedi.

# If you use TCP-Wrappers, this is the default directory where your
# daemons are (try, for instance, to find your in.telnetd or telnetd file)

$DAEMON_DIR='/usr/sbin';

# Indentation

$TAB="\t";

sub conv_header {
   print "# Jnetd.cf file - Automatically generated from inetd.conf by i2j\n\n";
}

sub conv_defaults {
   print "CORELIMIT 0\n";
}

sub conv_begblock {
   print "\n{\n";
}

sub conv_endblock {
   print "}\n";
}

sub conv_footer {
   conv_begblock;
   print "$TAB"."SERVICE info=9999 DESCRIPTION \"G2S info\" BUILTIN INFO\n";
   conv_endblock;
}

sub conv_service {
   my($service) = @_;
   print "$TAB"."SERVICE $service\n";
   if ($service =~ /^echo$/oi) {
      print "$TAB"."BUILTIN ECHO\n";
   } elsif ($service =~ /^discard$/oi) {
      print "$TAB"."BUILTIN DISCARD\n";
   }
}

sub conv_proto {
   my($socktype, $proto, $wait) = @_;
   unless ($proto =~ /^TCP$/oi) {
      print "$TAB"."PROTO $proto\n"
   }
}

sub conv_user {
   my($user) = @_;
   unless ($user eq 'root') {
      print "$TAB"."USER $user\n"
   }
}

sub conv_s {
   my(@s) = @_;
   
   if ($s[0] =~ /internal/oi) {
      return;
   }
   if ($s[0] =~ /\/tcpd$/o) {
      shift @s;
      unless ($s[0] =~ /^\//) {
	      $s[0] = "$DAEMON_DIR/$s[0]";
      }
   } else {
      $_ = $s[0];
      shift @s;
      $s[0] = $_;
   }
   if ($s[0] =~ /\/tcp-env$/o) {
      shift @s;
   }
   print "$TAB"."RUN @s\n";
}

conv_header;
conv_defaults;
while (<>) {
   chomp;
   /^\s*#/o and next;
   /^\s*(\S+)\s+(\S+)\s+(\S+)\s+(\S+)\s+(\S+)\s+(.+)\s*$/o or next;
   ($service, $socktype, $proto, $wait, $user, $s) = 
     ($1, $2, $3, $4, $5, $6) or next;
   @s = split /\s+/,$s or next;
   conv_begblock;
   conv_service($service);
   conv_proto($socktype, $proto, $wait);
   conv_user($user);
   conv_s(@s);
   conv_endblock;
}
conv_footer;
