/* ====================================================================
 * Emergency Audit Response System (EARS)
 * utils.c
 * --------------------------------------
 *
 * Copyright (c) 1997-1999 Tishina.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer. 
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. All advertising materials mentioning features or use of this
 *    software must display the following acknowledgment:
 *    "This product includes software developed by 
 *     Tishina <tishina@innocent.com" 
 *
 * 4. The names "Tishina" and "EARS" must not be used to
 *    endorse or promote products derived from this software without
 *    prior written permission. For written permission, please contact
 *    tishina@innocent.com.
 *
 * 5. Products derived from this software may not be called "EARS".
 *
 * 6. Redistributions of any form whatsoever must retain the following
 *    acknowledgment:
 *    "This product includes software developed by
 *     Tishina <tishina@innocent.com>
 *
 * THIS SOFTWARE IS PROVIDED BY THE APACHE GROUP ``AS IS'' AND ANY
 * EXPRESSED OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL TISHINA OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 * ====================================================================
 *
 */

#include "ears.h"



int strcheck(char *s1, char *s2) {
	int x;

	for (x=0; x!=strlen(s2); x++) {
		if (s1[x]!=s2[x]) return -1;
	}
	return 0;
}


void banner(void)
{

	fprintf(stdout,"-------------------------------\n");
	fprintf(stdout,"Emergency Audit Response System\n");
	fprintf(stdout,"%s\n", EARS_VER);
	fprintf(stdout,"Use 'help' for info...\n");
	fprintf(stdout,"-------------------------------\n\n");
}

int check_auth(void) 
{
	if ((getuid() && geteuid())!=0) return -1;
	return 0;
}

struct utmp *get_urec(char *user) 
{
	struct utmp *utmp;

	setutent();
	while((utmp=getutent())) {
/*		memset(utmp, 0, sizeof(struct utmp)); */
		if (user) {
			if (isalnum(user[0])) {
				if (strcmp(utmp->ut_user, user)==0) { 
					return utmp;
				}
			}
		} else {
			if (isalnum(utmp->ut_user[0])) printf("%s\n", show_urec(utmp)); 
		}
	}
	return NULL;
}

int snoop_x(void) 
{
return 1;
}

char *show_urec(struct utmp *utmp) 
{
	
	char *rec;
	if (!(rec=(char *)malloc(400*sizeof(char *)))) {
		perror(EARS_PROMPT);
		return (char *)-1;
	}
	if (utmp->ut_user) {
		sprintf(rec, "%10s\t[%2d]\t[%5d]\t%s\t%s",
				utmp->ut_user, utmp->ut_type, utmp->ut_pid, 
				utmp->ut_line,utmp->ut_host);
	}
	return rec;
}

void na(void)
{
	printf("%s: function not available.\n", EARS_PROMPT);
}

u_short cksum( u_short *buf, int nwords ) {
	unsigned long sum;
	for ( sum = 0; nwords > 0; nwords -- )
	sum += *buf++;
	sum = ( sum >> 16) + ( sum & 0xffff );
	sum += ( sum >> 16 );
	return ~sum ;
}

void resolve_address(struct sockaddr * addr, char *hostname, u_short port) {
	struct sockaddr_in *address;
	struct hostent *host;
	address = (struct sockaddr_in *)addr;
	(void) bzero( (char *)address, sizeof(struct sockaddr_in) );
	address->sin_family = AF_INET;
	address->sin_port = htons(port);
	address->sin_addr.s_addr = inet_addr(hostname);
	if ( (int)address->sin_addr.s_addr == -1) {
		host = gethostbyname(hostname);
		if (host) {
			bcopy( host->h_addr, (char *)&address->sin_addr,
			host->h_length);
		}
		else {
			herror("EARS");
			return;
		}
	}
}

int sendp( char * fromhost, int fromport, char * tohost, int toport ) 
{

	char *packet;	
	static struct sockaddr_in local, remote; 
	static int sock = 0;

#ifdef DEBUG
	printf("%s[%d] ---> %s[%d]\n", fromhost, fromport, tohost, toport);
#endif
	if ( !sock ) {
		resolve_address( (struct sockaddr *)&local, fromhost, fromport );
		resolve_address( (struct sockaddr *)&remote, tohost, toport );
		sock = socket( AF_INET, SOCK_RAW, 255 );
		if ( sock == -1 ) { 
			perror(EARS_PROMPT);
			return -1;
		}
	}

	packet = (char *)malloc( PACKETSIZE );
	if ( !packet ) { 	
		perror(EARS_PROMPT);
		return -1;
	}
	{ 
		struct tcphdr * fake_tcp;
		fake_tcp = ( struct tcphdr *)( packet + offsetTCP );
		fake_tcp->th_dport = htons(fromport);
		fake_tcp->th_sport = htons(toport);
		fake_tcp->th_seq	 = 0x1984;
	}
	{
		struct iphdr * fake_ip;
		fake_ip = ( struct iphdr *) ( packet + offsetIP ); 
		fake_ip->version = 4;
		fake_ip->tot_len = htons(0x2C);
		fake_ip->tos = 0;
		fake_ip->id = htons( getpid() & 255 ); 
		fake_ip->frag_off = 0;
		fake_ip->ttl = 24;
		fake_ip->check = 3805;
		fake_ip->ihl = 5; 
	bcopy( (char *)&local.sin_addr, &fake_ip->daddr, sizeof( fake_ip->daddr ) );
	bcopy( (char *)&remote.sin_addr,&fake_ip->saddr, sizeof( fake_ip->saddr ) );
		fake_ip->protocol = 6;
	}
	{
		struct icmphdr * icmp;
		icmp = ( struct icmphdr *)(packet + offsetICMP );
		icmp->type = 3;
		icmp->code = IVAL;
		icmp->un.gateway = 0;
		icmp->checksum = 0; 
		icmp->checksum = cksum( (u_short *)(icmp),  ICMPSIZE >> 1 );
	}
	{
		struct iphdr * real_ip;
		real_ip = ( struct iphdr *)packet;
		real_ip->version = 4; 
		real_ip->ihl = 5;
		real_ip->tot_len = htons(PACKETSIZE);
		real_ip->tos = ( 7 << 5) | 4;
		real_ip->ttl = 255;
		real_ip->protocol = 1; 
		real_ip->check = 0;
		real_ip->id = htons( 3 );
		real_ip->frag_off = 0;
		bcopy( (char *)&local.sin_addr, &real_ip->saddr, sizeof( real_ip->saddr ) );
	bcopy( (char *)&remote.sin_addr,&real_ip->daddr, sizeof( real_ip->daddr ) );
	real_ip->check = cksum( (u_short  *)packet, sizeof( struct iphdr ) >> 1 );
	}
	{
		int result;
		result= sendto( sock, packet, PACKETSIZE, 0, 
		(struct sockaddr *)&remote, sizeof( remote ) );
		if ( result != PACKETSIZE ) { 	
			perror(EARS_PROMPT); 
			return -1;
		}
	}
	free(packet);
	return 0;
}

char *ip_to_h(char *ip) 
{

	struct hostent *he;
	u_long addr;

	addr= inet_addr(ip);
	if (!(he = gethostbyaddr((char *)&addr, sizeof(addr), AF_INET))) {
		herror("EARS");
		return (char *)-1;
	}
	return he->h_name;
}

char *h_to_ip(char *host) 
{

	struct hostent *he;
	char *str;
	
	if (!(he=gethostbyname(host))) {
		herror("EARS");
		return (char *)-1;
	}
	if (!(str=inet_ntop(he->h_addrtype, he->h_addr_list[0]))) {
		return (char *)-1;
	}
	return str;  
}

void sig_child(int signo) {
	
	pid_t pid;
	int stat;
	while((pid=waitpid(-1, &stat, WNOHANG))>0); 
}

void sig_exit(int signo) {
	printf("\nInterrupted by signal %d.\n", signo);
	sigexit++;
	c_quit(NULL);
}
			
int kill_net(char *dest) 
{
	FILE *ptcp;
	char buff[B_SIZE];
	int x=0, con_q=0;
	struct conn_tcp tcp[MAX_TCP];
	
	memset(tcp, 0, MAX_TCP*sizeof(struct conn_tcp));
	if (!(ptcp=fopen(PROC_TCP, "r"))) {
		perror(EARS_PROMPT);
		return -1;
	}

	do {
		fgets(buff, sizeof(buff),ptcp);
		netto(buff, tcp, &con_q);
	} while(!feof(ptcp));
	fclose(ptcp);
	for (;x!=con_q; x++) {
#ifdef DEBUG
		printf("Con_Q=%d\n", con_q);
#endif
		if (tcp[x].state==ESTABLISHED && 
			strstr(tcp[x].remote_ip, dest)) {
#ifdef DEBUG
			printf("Match found to l%d r%d\n", tcp[x].lport,
					tcp[x].dport);
#endif
			sendp(tcp[x].local_ip, tcp[x].lport,
				tcp[x].remote_ip, tcp[x].dport); 
			con_q=0;	/* reset gcq */
			return 0;
		}
	}
	con_q=0;	/* reset global connection q */
	return -1;
}

char *inet_ntop(int fam, const void *addr)
{
	const u_char *p = (const u_char *)addr;
	char tmp[ADDR_LEN];
	char *tmp2;

	if (!(tmp2=malloc(ADDR_LEN*sizeof(char *)))) {
		perror(EARS_PROMPT);
		return (char *)-1;
	}
	if (fam == AF_INET) {
		sprintf(tmp, "%d.%d.%d.%d\n",
			p[0], p[1], p[2], p[3]);
		sscanf(tmp,"%s", tmp2);		
		return tmp2;
	}
	return (char *)-1;
}

int parse_categ(char *arg) 
{

	if (!arg) return T_ERROR;
	if (strchr(arg, '?')) return T_HELP;
	if (strchr(arg, '/')) return T_PATH;
        if (strstr(arg, "cert")) return T_CERT;
        if (strstr(arg, "trusted")) return T_TRUSTED; 
        if (strchr(arg, '@')) return T_SPEC;
	if (arg[0]=='X') return T_XS;
	if (isupper(arg[0])) return T_NET_PROT;
	if (strchr(arg, '.')) {
		if (isdigit(arg[0])) {
			return T_NET_IP;
		}
		else return T_NET_HOST;
	}
	if (isdigit(arg[0])) return T_PID;
	if (isalpha(arg[0])) return T_USER;
	return T_ERROR;
} 

int parse_stat(char *arg) 
{
	if (!arg) return S_ERROR;
	if (strchr(arg,'?')) return S_HELP;
	if (!isalpha(arg[0])) return S_ERROR;
	if (strstr(arg, PROC_STR)) return S_PROC;
	if (strstr(arg, NET_STR)) return S_NET;
	if (strstr(arg, USER_STR)) return S_USER;
	return S_ERROR;
}

void netto(char *line, struct conn_tcp *tcp, int *con_q) 
{

	unsigned long rxq, txq, time_len, retr;
	int local_port, rem_port, d, state, uid, timer_run; /* num; */
	char rem_addr[128], local_addr[128]; /* timers[64], buffer[1024]; */
	struct sockaddr_in localaddr, remaddr;
	char lip[20];
	char rip[20];


 sscanf(line,
          "%d: %[0-9A-Fa-f]:%X %[0-9A-Fa-f]:%X %X %lX:%lX %X:%lX %lX %d\n",
          &d, local_addr, &local_port, rem_addr, &rem_port, &state,
          &txq, &rxq, &timer_run, &time_len, &retr, &uid);



	sscanf(local_addr, "%X",
		&((struct sockaddr_in *)&localaddr)->sin_addr.s_addr);
	sscanf(rem_addr, "%X",
		&((struct sockaddr_in *)&remaddr)->sin_addr.s_addr);
	strcpy(lip, inet_ntoa(localaddr.sin_addr));
	strcpy(rip, inet_ntoa(remaddr.sin_addr));

#ifdef DEBUG
	printf("LOCA=%s [%d]\n", lip, local_port);
	printf("REMO=%s [%d]\n", rip, rem_port);
#endif

	if (rip[0]!='0' && lip[0]!='0' && rem_port<50000) {
		sprintf(tcp[*con_q].local_ip, "%s", lip);
		sprintf(tcp[*con_q].remote_ip, "%s", rip);
		tcp[*con_q].lport=local_port;
		tcp[*con_q].dport=rem_port;
		tcp[*con_q].state=state;
		(*con_q)++;
	}
}

int stat_net(char *arg) 
{

	char buffer[B_SIZE];
	FILE *proc;
	int x=0, con_q=0;
	struct conn_tcp tcp[MAX_TCP];

	con_q=0;

	memset(tcp, 0, MAX_TCP*sizeof(struct conn_tcp));
	if (!(proc = fopen(PROC_TCP, "r"))) {
		perror(EARS_PROMPT);
		return -1;
	}

	do { 
		fgets(buffer, sizeof(buffer), proc);
		netto(buffer, tcp, &con_q);
	} while (!feof(proc));
	fclose(proc);

	if (arg) {
		for (;x!=con_q; x++) {
			if (strstr(ip_to_h(tcp[x].remote_ip), arg)) {
				printf("Verified source: %s [%d]\n", ip_to_h(tcp[x].remote_ip), tcp[x].dport);
				return 0;
			}
		}
		return -1;
	}

	head_net();
	for (x=0;x!=con_q; x++) {
		printf("%16s [%4d]\t\t%16s [%d]\t[%4d]\n", ip_to_h(tcp[x].remote_ip), tcp[x].dport,
			tcp[x].local_ip, tcp[x].lport, tcp[x].state);	
	}
	head_if();
	check_pm();
	return 0;
		
}

void head_net(void)
{
	printf("Remote [port]          \t  \tLocal [port]         \t[state]\n");
	printf("-----------------------\t  \t---------------------\t-------\n");
}

void head_if(void)
{
	printf("\n---------\t-------\n");
	printf("Interface\tSniffed\n");
	printf("---------\t-------\n");
}
	
int stat_proc(void) 
{
	head_proc();
	dir();
	return 0;
}

void head_proc(void)
{
	printf("[PID]    \t[PPID]   \t[STATE]\t(COMMAND)\n");
	printf("---------\t---------\t-------\t---------\n");
}

int parse_pstat(int proc) {

	char plist[1000];
	char fdir[80];
	struct proc *pstat;
	FILE *procfd;
	int ppid;
	

	sprintf(fdir, "%s/%d/stat", PROC_LOC, proc);
        if (!(procfd = fopen(fdir, "r"))) {
                perror(EARS_PROMPT);
		return -1;
        }


	if (!(pstat = malloc(sizeof(struct proc)))) {
		perror(EARS_PROMPT);
		return -1;
	}

        do {
                fgets(plist, sizeof(plist), procfd);
        } while (!feof(procfd));
        fclose(procfd);

	sscanf(plist, "%d %s %c %d %d %d %d", &pstat->pid, pstat->comm,
			&pstat->state, &pstat->ppid, 
			&pstat->pgrp, &pstat->session, &pstat->tty);
	printf("[%7d]\t[%7d]\t[%c]\t%s\n", pstat->pid, pstat->ppid,
			pstat->state, pstat->comm);
	ppid=pstat->ppid;
	free(pstat);
	return ppid;
}
	
int dir(void) 
{

	DIR *pd;
	struct dirent *dir;

	if (!(pd=opendir(PROC_LOC))) { 
		perror(EARS_PROMPT);
	}

	while((dir=readdir(pd))) { 

		if (isdigit(dir->d_name[0])) {
			parse_pstat(atoi(dir->d_name));
		}
	}
	closedir(pd);
	return 0;
}

int stat_user(void)
{
	head_user();
	printf("\n");
	get_urec(NULL);
	return 0;
}

void head_user(void)
{
	
	printf("USER\t\t[type]\t[pid]\tDEVICE\tHOST\n");
	printf("----------\t------\t-------\t------\t----");
}

int trace_net(char *arg) 
{

	char **pseudo;
	pseudo=(char **)malloc(1000);
	if (!(pseudo[0]=(char *)malloc(100*sizeof(char *)))) {
		perror(EARS_PROMPT);
		return -1;
	}	
	if (!(pseudo[1]=(char *)malloc(100*sizeof(char *)))) {
		perror(EARS_PROMPT);
		return -1;
	}	
	sprintf(pseudo[0], "%s", arg);
	sprintf(pseudo[1], "%s", arg);
	pseudo[2]=NULL;
	tracer(2, pseudo);
	free(pseudo[0]);
	free(pseudo[1]);
	return 0;
}

int trace_proc(char *arg)
{

	head_proc();
	if (strcmp(arg,"1")==0) {
		printf("%s(init) is a root process.\n", arg); return 0;
	}  
	parse_pstat(parse_pstat(atoi(arg)));
	return 0;
}	

int trace_user(char *arg)
{

	struct utmp *utmp;
	if (!(utmp=get_urec(arg))) return -1;

	head_user();
	printf("\n%s\n", show_urec(utmp));
	if (isalnum(utmp->ut_host[0])) {
		if (stat_net(utmp->ut_host) <0) {
			printf("%s (not verified)\n", utmp->ut_host);
		}
	}
	return 0;
}

int deny_if(char *arg)
{

	int sd;
	struct ifreq ifr;

	if ((sd=socket(AF_INET, SOCK_DGRAM, 0))<0) {
		perror(EARS_PROMPT);
		return -1;
	}
	strcpy(ifr.ifr_name, arg);
	if (ioctl(sd, SIOCGIFFLAGS, &ifr)<0) {
		perror(EARS_PROMPT);
		return -1;
	}
	if ((ifr.ifr_flags &IFF_UP)==0) {
		printf("%s is already down.\n", arg); return -1;
	}
	ifr.ifr_flags=0;	/* BS */
	if (ioctl(sd, SIOCSIFFLAGS, &ifr)<0) {
		perror(EARS_PROMPT);
		return -1;
	}
	close(sd);
	return 0;
}

int deny_file(char *arg)
{
	int fd;
	struct flock fl;

	if ((fd=open(arg, O_RDWR))<0) {
		perror(EARS_PROMPT);
		return -1;
	}
	fl.l_type=F_WRLCK;
	fl.l_whence=SEEK_SET;
	fl.l_start=0;
	fl.l_len=0;
	if (fcntl(fd,F_SETLKW, &fl)<0) {
		perror(EARS_PROMPT);
		return -1;
	}
	return 0;
}

int deny_net(char *arg, int categ)
{
	char buf[250];
	if (categ==T_NET_HOST||categ==T_NET_IP) {
		sprintf(buf,"%s -I -i deny -S %s", IPFW_BIN, arg);
		system(buf);
		return 0;
/*
		if (fork()==0) {
			if (execl(IPFW_BIN,"ipfwadm","-I","-i","deny","-S", arg,(char *)0)<0) {
				exit(1);
				return -1;
			}
			exit(1);
		}
		return 0;*/
	}
	if (categ==T_NET_PROT) {
		sprintf(buf,"%s -I -i deny -P %s", IPFW_BIN, arg);
		system(buf);
		return 0;
	} else return -1;
}

int snoop_net(char *arg)
{
	char buf[250];
	sprintf(buf,"%s host %s", TCPD_BIN, arg);
	system(buf);		/* hell with execl() */
	return 0;
}

int snoop_user(char *arg)
{
	na();
	return 0;
}

int snoop_pid(char *arg)
{
	na();
	return 0;
}

int report_static(char *arg, char *load)
{
	char buf[250];
#ifdef DEBUG
	sprintf(buf,"%s -v %s < %s", SM_BIN, arg, load);
#endif
	sprintf(buf,"%s %s < %s", SM_BIN, arg, load);
	system(buf);
	return 0;
}

int report_trusted(void)
{
	na();
	return 0;
}

			

void to_lower(char *str) 
{
	int x;
	for (x=0; x!=strlen(str); x++) {
		str[x]=tolower(str[x]);
	}
} 

void trace_help(void)
{
	printf("\ntrace <var> -- Determine the source of:\n");
	printf("           \t<IP>   -- Find <IP> route.\n");
	printf("           \t<host> -- \"\"\n");
	printf("           \t<user> -- Find source host of <user>.\n");
	printf("           \t<pid>  -- Find parent id of <pid>.\n\n");
}

void kill_help(void)
{
	printf("\nkill <var> -- Destroy:\n");
	printf("           \t<IP>   -- End <IP> connection.\n");
	printf("           \t<host> -- \"\"\n");
	printf("           \t<user> -- Logoff <user>.\n");
	printf("           \t<pid>  -- Kill <pid> (SIGKILL).\n\n");
}

void stat_help(void)
{
	printf("\nstat \"var\" -- Provide statistics on:\n");
	printf("           \t\"proc\" -- Process table\n");
	printf("           \t\"user\" -- User environment\n");
	printf("           \t\"net\"  -- Network status\n\n");
}

void deny_help(void)
{
	printf("\ndeny <var> -- Deny access to resources:\n");
	printf("           \t<IP>         -- Set firewall to block <IP>.\n");
	printf("           \t<host>       -- \"\"\n");
	printf("           \t<interface>  -- Shutdown network <interface>.\n");
	printf("           \t<file>       -- Lock <file>.\n\n");
}

void snoop_help(void)
{
	printf("\nsnoop <var> -- Monitor resources:\n");
	printf("           \t<IP>         -- Invoke tcpdump on <IP>\n");
	printf("           \t<host>       -- \"\"\n");
	printf("	   \t\"X\"	     -- Capture keystrokes from X server.\n");
	printf("           \t<user>       -- (N/A)Capture <user>'s keystrokes.\n");
	printf("           \t<pid>        -- (N/A)Monitor <pid>'s calls.\n\n");
}

void report_help(void)
{
	printf("\nreport <var> -- Report event log/report to:\n");
	printf("           \t\"cert\"       -- CERT.\n");
	printf("           \t\"trusted\"    -- (N/A) Trusted hosts.\n");
	printf("           \t<user@host>  -- Specified.\n");
}
