/* ====================================================================
 * Emergency Audit Response System
 * ears.h
 * -------------------------------
 *
 * Copyright (c) 1997-1999 Tishina Syndicate.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer. 
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. All advertising materials mentioning features or use of this
 *    software must display the following acknowledgment:
 *    "This product includes software developed by 
 *     Tishina <tishina@innocent.com" 
 *
 * 4. The names "Tishina" and "EARS" must not be used to
 *    endorse or promote products derived from this software without
 *    prior written permission. For written permission, please contact
 *    tishina@innocent.com.
 *
 * 5. Products derived from this software may not be called "EARS".
 *
 * 6. Redistributions of any form whatsoever must retain the following
 *    acknowledgment:
 *    "This product includes software developed by
 *     Tishina <tishina@innocent.com>
 *
 * THIS SOFTWARE IS PROVIDED BY THE APACHE GROUP ``AS IS'' AND ANY
 * EXPRESSED OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL TISHINA OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 * ====================================================================
 *
 */



#include <stdio.h>
#include <stdlib.h>
#include <signal.h>
#include <string.h>
#include <unistd.h>
#include <ctype.h> 

#include <sys/types.h>
#include <sys/socket.h>
#include <sys/stat.h>
#include <sys/ioctl.h>
#include <net/if.h>
#include <fcntl.h>
#include <sys/file.h>
#include <netdb.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <netinet/in_systm.h>
#include <netinet/tcp.h>
#include <netinet/ip.h>
#include <netinet/ip_icmp.h>

#include <utmp.h>
#include <dirent.h>


/* common defines */

#define EARS_PROMPT	"EARS"
#define COMM_LEN	30
#define ARG_LEN		50
#define PROMPT		"EARS> "
#define REQ_CNT		(sizeof(coms)/sizeof(struct req))
#define EARS_VER	"v0.7 linux x86"
#define DEF_SIG		SIGKILL		/* a little harsh, but... */
#define PROC_LOC	"/proc"

#define IPFW_BIN	"/sbin/ipfwadm"
#define TCPD_BIN	"/usr/sbin/tcpdump"
#define SM_BIN		"/usr/bin/sendmail"
#define CERT_REPORT	"/usr/local/ears/CERT_FORM"
#define EARS_REPORT	"/usr/local/ears/ears.log"

#define CERT_MAIL	"cert@cert.org"
#define ARG1_SIZE	50		/* for sub arguments */
#define ARG2_SIZE	80


int sigexit;	/* abnormal termination */
/* 
 * parse_categ() returns 
 */

enum {
	T_ERROR=-1,
	T_PID,
	T_USER,
	T_NET_IP,
	T_NET_HOST,
	T_NET_PROT,
	T_HELP,
	T_PATH,
	T_CERT,
	T_TRUSTED,
	T_SPEC,
	T_XS
};


/* 
 * parse_stat() returns 
 */

enum {
	S_ERROR=-1,
	S_PROC,
	S_USER,
	S_NET,
	S_DEFAULT,
	S_HELP
};

#define NET_STR		"net"
#define PROC_STR	"proc"
#define USER_STR	"user"
#define B_SIZE		8192


#define IVAL		2		/* icmp type */
#define MAX_TCP		100		/* maximum ESTABLISHED tcp conns? */
#define PROC_TCP	"/proc/net/tcp"
#define PROC_UDP	"/proc/net/udp"
#define ADDR_LEN	16 		/* ipv4 length */

#define PACKETSIZE ( sizeof( struct iphdr ) + sizeof( struct icmphdr ) +  \
			sizeof( struct iphdr ) + 8 )
#define ICMPSIZE   ( sizeof( struct icmphdr ) + sizeof( struct iphdr ) + 8 )
#define offsetTCP  ( sizeof( struct iphdr ) + sizeof( struct icmphdr ) + \
			sizeof( struct iphdr ) )
#define offsetIP   ( sizeof( struct iphdr ) + sizeof( struct icmphdr ) )
#define offsetICMP ( sizeof( struct iphdr ) )
#define offsetRIP  ( 0 )


typedef int (Cpntr) (char *);
int categ_ret;

struct req {
	char comm[COMM_LEN];
	char res[200];
	Cpntr *call;
};	

struct conn_tcp {
        char local_ip[15];
        char remote_ip[15];
        int lport, dport;
	int state;
};

/*
 * TCP states 
 */

enum {			
	ESTABLISHED=1,
	SYN_SENT,
	SYN_RECV,
	FIN_WAIT1,
	FIN_WAIT2,
	TIME_WAIT,
	CLOSE,
	CLOSE_WAIT,
	LAST_ACK,
	LISTEN,
	CLOSING
};


struct proc {
        int pid;
        char comm[100];
        char state;
        int ppid,pgrp,session;
        int tty;
};

/* ***************************************************** */
/* ***************************************************** */


	
/* 
 * c_stat() types 
 */
	
int parse_pstat(int);	/* parse /proc/x/stat with ppid return */
int dir(void);
int parse_stat(char *);
void netto(char *, struct conn_tcp *, int *);
int check_pm(void);
void stat_help(void);
int stat_net(char *);
int stat_proc(void);
int stat_user(void);


/* 
 * c_trace() types 
 */

int trace_net(char *);
int trace_proc(char *);
int trace_user(char *);
int tracer(int, char **);
void trace_help(void);


/*  
 * c_kill() types
 */

int kill_net(char *);
void kill_help(void);


/* 
 * c_deny() types 
 */

int deny_if(char *);
int deny_file(char *);
int deny_net(char *, int);
void deny_help(void);


/*
 * c_snoop() types
 */

int snoop_net(char *);
int snoop_pid(char *);
int snoop_user(char *);
int snoop_x(void); 
void snoop_help(void);


/*
 * c_report() types
 */

int report_static(char *, char *);
int report_trusted(void);
void report_help(void);


/* 
 * common types 
 */

int strcheck(char *, char *);
int check_auth(void);
int parse_categ(char *);

void sig_child(int signo);
void sig_exit(int signo);
void to_lower(char *); 
void banner(void);
void head_proc(void);
void head_user(void);
void head_net(void);
void head_if(void);
void na(void);		/* temp banner */

struct utmp *get_urec(char *);
char *show_urec(struct utmp *);

u_short cksum( u_short *, int );
void resolve_address(struct sockaddr * addr, char *hostname, u_short port); 
int sendp( char *, int, char *, int);
char *inet_ntop(int, const void*);
char *ip_to_h(char *);
char *h_to_ip(char *);


/* 
 * root types 
 */

int c_quit(char *), c_help(char *), c_clear(char *), c_comm(char *);
int c_kill(char *), c_stat(char *), c_report(char *);
int c_trace(char *), c_deny(char *), c_snoop(char *);



