/* ====================================================================
 * Emergency Audit Response System (EARS)
 * Version 0.7 
 * ears.c
 * --------------------------------------
 *
 * Copyright (c) 1997-1999 Tishina Syndicate.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer. 
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. All advertising materials mentioning features or use of this
 *    software must display the following acknowledgment:
 *    "This product includes software developed by 
 *     Tishina <tishina@innocent.com" 
 *
 * 4. The names "Tishina" and "EARS" must not be used to
 *    endorse or promote products derived from this software without
 *    prior written permission. For written permission, please contact
 *    tishina@innocent.com.
 *
 * 5. Products derived from this software may not be called "EARS".
 *
 * 6. Redistributions of any form whatsoever must retain the following
 *    acknowledgment:
 *    "This product includes software developed by
 *     Tishina <tishina@innocent.com>
 *
 * THIS SOFTWARE IS PROVIDED BY THE APACHE GROUP ``AS IS'' AND ANY
 * EXPRESSED OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL TISHINA OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 * ====================================================================
 *
 */

#include "ears.h"



static struct req coms[]={
        {"quit","Exit EARS", c_quit},
	{"!", "Drop to shell", c_comm},
	{"clear","Reset terminal", c_clear},
        {"help", "Hmm", c_help},
        {"kill", "Kill resource", c_kill},
        {"stat", "Statistics on resource", c_stat},
        {"trace", "Determine source of resource", c_trace},
	{"deny", "Deny access to resource", c_deny},
	{"snoop", "Monitor resource", c_snoop},
	{"report", "Submit log/report", c_report}  
};


int
main(int argc, char **argv) {
	
	char buff[COMM_LEN+ARG_LEN];
	char comm[COMM_LEN];
	char arg[ARG_LEN];
	int x, ret;


	signal(SIGCHLD, sig_child);
	signal(SIGTERM, sig_exit); 
	signal(SIGHUP, sig_exit);
	signal(SIGSEGV, sig_exit);
	signal(SIGINT, sig_exit);
	signal(SIGBUS, sig_exit);

	banner(); 
	if (check_auth()<0) {
		c_quit("root required (id&euid).");
	}

	while(1) {
		memset(buff, 0, COMM_LEN+ARG_LEN);
		memset(comm, 0, COMM_LEN);
		memset(arg, 0, ARG_LEN);
		printf("%s",PROMPT);
		gets(buff);
		sscanf(buff,"%s %s", comm, arg);
		if (strlen(comm)<(COMM_LEN+ARG_LEN)) { 
			for (x=0;x!=(sizeof(coms)/sizeof(struct req)); x++) {
				if (strncmp(comm, coms[x].comm,strlen(coms[x].comm))==0) {
					if (isalnum(arg[0])||strchr(arg,'/')||arg[0]=='?') {
						ret = (*(coms[x].call))(arg);
					} else {
						ret = (*(coms[x].call))(NULL);
					}
					x=1; 	/* avoid error check */
					break;
				}
			}
		} else { 
			x=-1;		/* set buffer too long */ 
			printf("%s: too long.\n", EARS_PROMPT);
		}
		if (++x>=REQ_CNT || x<1) {
			printf("%s: que? use 'help' for info.\n", EARS_PROMPT);
		}
	}
}	


int c_help(char *arg)
{
        int x;
        printf("\nSynopsis of available commmands:\n");
	printf("<command> ? displays details.\n\n");
        for (x=0;x!=REQ_CNT; x++) {
                printf("\t%s\t -- %s\n", coms[x].comm, coms[x].res);
        }
	return 0;
}

