/* ====================================================================
 * Emergency Audit Response System (EARS)
 * c_deny.c                    
 * --------------------------------------
 *
 * Copyright (c) 1997-1999 Tishina Syndicate.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer. 
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. All advertising materials mentioning features or use of this
 *    software must display the following acknowledgment:
 *    "This product includes software developed by 
 *     Tishina Syndicate <tishina@innocent.com>" 
 *
 * 4. The names "Tishina Syndicate" and "EARS" must not be used to
 *    endorse or promote products derived from this software without
 *    prior written permission. For written permission, please contact
 *    tishina@innocent.com.
 *
 * 5. Products derived from this software may not be called "EARS".
 *
 * 6. Redistributions of any form whatsoever must retain the following
 *    acknowledgment:
 *    "This product includes software developed by
 *     Tishina Syndicate<tishina@innocent.com>
 *
 * THIS SOFTWARE IS PROVIDED BY THE APACHE GROUP ``AS IS'' AND ANY
 * EXPRESSED OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL TISHINA OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 * ====================================================================
 *
 */

#include "ears.h"



int c_deny(char *arg) 
{

	categ_ret = parse_categ(arg);

	switch(categ_ret) {

	case T_ERROR:		
				printf("EARS: invalid argument(s) <%s>.\n", arg);
				return -1;

	case T_NET_IP:		
				if (deny_net(arg, T_NET_IP)<0) {
					perror("EARS");
					return -1;
				}	
				printf("%s: rule sent.\n", EARS_PROMPT);
				return 0;
	case T_NET_HOST:		
				if (deny_net(arg, T_NET_HOST)<0) {
					perror("EARS");
					return -1;
				}	
				printf("%s: rule sent.\n", EARS_PROMPT);
				return 0;

	case T_NET_PROT:
				to_lower(arg);
				if (deny_net(arg, T_NET_PROT)<0){
					perror("EARS");
					return -1;
				}
				printf("%s: rule set.\n", EARS_PROMPT);
				return 0;
	case T_PATH:
				if (deny_file(arg)<0) {
					printf("EARS: unable to lock %s.\n", arg);
					return -1;
				}
				return 0;

	case T_USER:		/* actually interface */
				if (deny_if(arg)<0) {
					printf("EARS: unable to shutdown %s.\n",
						 arg);
					return -1;
				}
				printf("%s: %s down.\n", EARS_PROMPT, arg);
				return 0; 
	case T_HELP:
				deny_help();
				return 0;
	}
	return 0;
}

