/* Released under the GNU General Public License zaUB6auFOblOo */

#include <unistd.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <errno.h>
#include <unistd.h>
#include <netdb.h>
#include <time.h>
#include <crypt.h>

#include <netinet/in.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/wait.h>
#include <arpa/inet.h>

/* protocols stuff */

#define MSG        32
#define WANT     0x10
#define HAVE     0x20
#define TABLE     256

#ifndef TIMEOUT
#define TIMEOUT    42
#endif

#ifndef CHUNK
#define CHUNK  750521
#endif

#ifndef PORT
#define PORT     2001
#endif

#ifndef JOBS
#define JOBS      512
#endif

/* 1 code, 13 pw, 8 start, 8 stop */

char table[TABLE];
  
int bump(char *s, int count)
{
  int result=0;

  int i;

  while(count>0){
    i=7;
    count--;

    while((i>=0)&&((s[i]=table[s[i]])=='\0')){
      s[i]=table[s[i]];
      i--;
      if(i<0){
        count=0;
        result=1;
      }
    }
  }

  return result;
}

int dumprange(char *s)
{
  int j;
printf("[");
  for(j=0;j<8;j++){
    putc(s[j],stdout);
  }
printf("] to [");
  for(j=8;j<16;j++){
    putc(s[j],stdout);
  }
printf("]");
  return 0;
}

int main(int argc, char **argv)
{
  int ufd;
  struct sockaddr_in uaddr;
  struct sockaddr_in raddr;
  int addrlen;
  fd_set uset;
  int got;

  char alpha[MSG],beta[MSG];

  char jobs[JOBS][16];
  int  jobwait[JOBS];
  int  waitmax,waitindex;
  char low[9],high[9];
  char word[14];
  char salt[3];
  char range[16];
  char op;
  int  count;
  char set[]="bcdfghjklmnpqrstvwx1234567890aeiouyz./BCDFGHJKLMNPQRSTVWXAEIOUYZ";

  int i,j,f;

  uaddr.sin_port       =htons((unsigned short)PORT);
  uaddr.sin_family     =AF_INET;
  uaddr.sin_addr.s_addr=htonl(INADDR_ANY);
  if((ufd=socket(PF_INET,SOCK_DGRAM,0))==-1){
    perror("socket");
    exit(1);
  }
  addrlen=sizeof(struct sockaddr_in);

  if(bind(ufd,(struct sockaddr *)&uaddr,sizeof(uaddr))){
    perror("bind");
    exit(1);
  }

  memset(table,'\0',TABLE);
  for(i=0;set[i]!='\0';i++){
    table[set[i]]=set[i+1];
  }
  table['\0']=set[0];

  op=WANT;

  count=0;

  if(argc<2){
    fprintf(stderr,"Need a password\n");
    exit(1);
  }

  strncpy(word,argv[1],14);
  strncpy(salt,argv[1],3);
  salt[2]='\0';
  word[13]='\0';
  for(j=0;argv[1][j]!='\0';j++)argv[1][j]='\0';

  memset(low,'\0',9);
  if(argc<3){
    low[7]=set[0];
  } else {
    i=strlen(argv[2]);
    if(i>8){
      fprintf(stderr,"Not a valid starting position\n");
      exit(1);
    }
    strncpy(low+(8-i),argv[2],i);
    for(j=0;argv[2][j]!='\0';j++)argv[2][j]='\0';
  }

  memcpy(high,low,9);
  bump(high,CHUNK);

  memcpy(range,low,8);
  memcpy(range+8,high,8);

  for(i=0;i<JOBS;i++){
    memset(jobs[i],'\0',16);
    jobwait[i]=0;
  }
  f=0;

printf("Find [%s] : First chunk ",word);
dumprange(range);
printf("\n");

  while(1){
    FD_ZERO(&uset);
    FD_SET(ufd,&uset);
    if(select(ufd+1, &uset, NULL, NULL, NULL) == -1) {
      perror("select");
      exit(1);
    }
    if(FD_ISSET(ufd,&uset)){
      memset(alpha,0,MSG);
      if((got=recvfrom(ufd,alpha,MSG,0,(struct sockaddr *)&raddr,&addrlen))<0){
        perror("recvfrom");
      } else {
        switch(alpha[0]){
          case WANT :
            /* immediately send next block back */
            beta[0]=op;
            memcpy(beta+1,word,13);
            memcpy(beta+14,range,16);
            if(sendto(ufd,beta,MSG,0,(struct sockaddr *)&raddr,sizeof(raddr))<0){
              perror("sendto");
            }
      
            /* figure out if we have a match or timeout */
            f=count;
            waitmax=0;
            waitindex=0;
            for(i=0;i<count;i++){
              if((f==count)&&(memcmp(jobs[i],alpha+14,16)==0)){
                f=i;
printf("Processed job [%d] ",f);
                memcpy(jobs[f],beta+14,16);
                jobwait[i]=0;
              } else {
                jobwait[i]=jobwait[i]+1;
                if(jobwait[i]>waitmax){
                  waitmax=jobwait[i];
                  waitindex=i;
                }
              }
            }
            if(f==count){
              if(count<JOBS){
                memset(jobs[f],'\0',16);
                if(memcmp(jobs[f],alpha+14,16)==0){
printf("New job [%d] ",f);
                  memcpy(jobs[f],beta+14,16);
                  jobwait[f]=0;
                  count++;
                } else {
printf("Old or fake job [%d] ",f);
                  f=(-1);
                }
              } else {
printf("Reached limit [%d], ignoring client ",f);
                f=(-1);
              }
            }

printf("[%s:%d] :",inet_ntoa(raddr.sin_addr),ntohs(raddr.sin_port));

            if((TIMEOUT*(count+1))<waitmax){
printf("\nTimeout for job [%d] :",waitindex);
              memcpy(range,jobs[waitindex],16);
              for(i=waitindex+1;i<count;i++){
                memcpy(jobs[i-1],jobs[i],16);
                jobwait[i-1]=jobwait[i];
              }
              count--;
            } else {
              if(f!=(-1)){
                memcpy(low,high,8);
                bump(high,CHUNK);
                memcpy(range,low,8);
                memcpy(range+8,high,8);
              }
            }

printf(" Next chunk ");
dumprange(range);
printf("\n");

            break;
          case HAVE:
            alpha[9]='\0';
            if(strcmp(crypt(alpha+1,salt),word)==0){
printf("Found it [%s:%d] : [%s] is [%s]\n",inet_ntoa(raddr.sin_addr),ntohs(raddr.sin_port),word,alpha+1);
              op=HAVE;
            } else {
printf("False claim [%s:%d] : [%s] is not [%s]\n",inet_ntoa(raddr.sin_addr),ntohs(raddr.sin_port),word,alpha+1);
            }
          break;
          default:
            printf("Unknown message <0x%02x>\n",alpha[0]);
          break;
        }
      }
    }
  }

  return 0;
}
