/* Released under the GNU General Public License zaUB6auFOblOo */

#include <unistd.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <errno.h>
#include <unistd.h>
#include <netdb.h>
#include <time.h>
#include <crypt.h>

#include <netinet/in.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/wait.h>
#include <netinet/in.h>
#include <arpa/inet.h>

/* protocols stuff */

#define MSG        32
#define WANT     0x10
#define HAVE     0x20
#define TABLE     256

#ifndef PORT
#define PORT     2001
#endif

/* 1 code, 13 pw, 8 start, 8 stop */

char table[TABLE];
  
void bump(char *s)
{
  int i=7;

  while((i>=0)&&((s[i]=table[s[i]])=='\0')){
    s[i]=table[s[i]];
    i--;
  }

}

int main(int argc, char **argv)
{
  int result;

  int ufd;
  struct sockaddr_in raddr;
  struct sockaddr_in uaddr;
  struct hostent    *rname;

  int addrlen;

  char alpha[MSG];
  char word[14];
  char salt[3],low[9],high[9];
  char *answer;
  int f,d;

  char set[]="bcdfghjklmnpqrstvwx1234567890aeiouyz./BCDFGHJKLMNPQRSTVWXAEIOUYZ";
  int i,j;

  if(argc<2){
fprintf(stderr,"Need a hostname argument\n");
    exit(1);
  }

  chdir("/");

  memset(table,'\0',TABLE);
  for(i=0;set[i]!='\0';i++){
    table[set[i]]=set[i+1];
  }
  table['\0']=set[0];

  uaddr.sin_port       =htons(0);
  uaddr.sin_family     =AF_INET;
  uaddr.sin_addr.s_addr=htonl(INADDR_ANY);

  if(argc<3){
    raddr.sin_port     =htons((unsigned short)PORT);
  } else {
    raddr.sin_port     =htons((unsigned short)atoi(argv[2]));
  }
  raddr.sin_family     =AF_INET;

  if(inet_aton(argv[1],&(raddr.sin_addr))==0){
    rname=gethostbyname(argv[1]);
    if(rname==NULL){
fprintf(stderr,"Could not resolve <%s>\n",argv[1]);
      exit(1);
    }
    else{
      if(rname->h_addrtype==AF_INET){
        raddr.sin_addr=*(struct in_addr *)rname->h_addr;
      }
      else{
fprintf(stderr,"Can not deal with address type\n");
        exit(1);
      }
    }
  }

  addrlen=sizeof(struct sockaddr_in);

  if((ufd=socket(PF_INET,SOCK_DGRAM,0))==-1){
    perror("socket");
    exit(1);
  }

  if(bind(ufd,(struct sockaddr *)&uaddr,sizeof(uaddr))){
    perror("bind");
    exit(1);
  }

  for(i=1;i<argc;i++){
    j=0;
    while(argv[i][j]!='\0'){
      argv[i][j]='\0';
      j++;
    }
  }

  for(i=0;i<256;i++){
    if(i!=ufd)close(i);
  }

  setsid();

  nice(1);
  
  if(fork()){
    exit(1);
  }

  memset(alpha,'\0',MSG);
  alpha[0]=WANT;
  do{
    if(sendto(ufd,alpha,MSG,0,(struct sockaddr *)&raddr,sizeof(raddr))==MSG){
      if(recvfrom(ufd,alpha,MSG,0,(struct sockaddr *)&raddr,&addrlen)==MSG){
        if(alpha[0]==WANT){
          memcpy(word,alpha+1,13);
          word[13]='\0';
          memcpy(salt,alpha+1,2);
          salt[2]='\0';

          memcpy(low,alpha+14,8);
          low[8]='\0';
          memcpy(high,alpha+22,8);
          high[8]='\0';

/*fprintf(stderr,"Should start work on <%s>\n",word);*/
          for(f=0;(f<8)&&(low[f]=='\0');f++);
          for(d=0;(d<8)&&(low[d]==high[d]);d++);

          if(f==8){
/*fprintf(stderr,"Received useless start position\n");*/
            exit(1);
          } else {
/*fprintf(stderr,"Start is <%s>\n",low+f);*/


LOOP:
          answer=crypt(low+f,salt);
/*fprintf(stderr,"Crypting <%s> into <%s>\n",low+f,answer);*/
          if(answer[2]==word[2]){
            if(strcmp(answer+3,word+3)==0){
              alpha[0]=HAVE;
              strcpy(alpha+1,low+f);
              while(sendto(ufd,alpha,MSG,0,(struct sockaddr *)&raddr,sizeof(raddr))!=MSG){
                sleep(rand()%3600);
              }
              exit(0);
            }
          }
          switch(low[7]){
            case 'b':
              low[7]='c';
              break;
            case 'c':
              low[7]='d';
              break;
            case 'd':
              low[7]='f';
              break;
            case 'f':
              low[7]='g';
              break;
            case 'g':
              low[7]='h';
              break;
            case 'h':
              low[7]='j';
              break;
            case 'j':
              low[7]='k';
              break;
            case 'k':
              low[7]='l';
              break;
            case 'l':
              low[7]='m';
              break;
            case 'm':
              low[7]='n';
              break;
            case 'n':
              low[7]='p';
              break;
            case 'p':
              low[7]='q';
              break;
            case 'q':
              low[7]='r';
              break;
            case 'r':
              low[7]='s';
              break;
            case 's':
              low[7]='t';
              break;
            case 't':
              low[7]='v';
              break;
            case 'v':
              low[7]='w';
              break;
            case 'w':
              low[7]='x';
              break;
            case 'x':
              low[7]='1';
              break;
            case '1':
              low[7]='2';
              break;
            case '2':
              low[7]='3';
              break;
            case '3':
              low[7]='4';
              break;
            case '4':
              low[7]='5';
              break;
            case '5':
              low[7]='6';
              break;
            case '6':
              low[7]='7';
              break;
            case '7':
              low[7]='8';
              break;
            case '8':
              low[7]='9';
              break;
            case '9':
              low[7]='0';
              break;
            case '0':
              low[7]='a';
              break;
            case 'a':
              low[7]='e';
              break;
            case 'e':
              low[7]='i';
              break;
            case 'i':
              low[7]='o';
              break;
            case 'o':
              low[7]='u';
              break;
            case 'u':
              low[7]='y';
              break;
            case 'y':
              low[7]='z';
              break;
            case 'z':
              low[7]='.';
              break;
            case '.':
              low[7]='/';
              break;
            case '/':
              low[7]='B';
              break;
            case 'B':
              low[7]='C';
              break;
            case 'C':
              low[7]='D';
              break;
            case 'D':
              low[7]='F';
              break;
            case 'F':
              low[7]='G';
              break;
            case 'G':
              low[7]='H';
              break;
            case 'H':
              low[7]='J';
              break;
            case 'J':
              low[7]='K';
              break;
            case 'K':
              low[7]='L';
              break;
            case 'L':
              low[7]='M';
              break;
            case 'M':
              low[7]='N';
              break;
            case 'N':
              low[7]='P';
              break;
            case 'P':
              low[7]='Q';
              break;
            case 'Q':
              low[7]='R';
              break;
            case 'R':
              low[7]='S';
              break;
            case 'S':
              low[7]='T';
              break;
            case 'T':
              low[7]='V';
              break;
            case 'V':
              low[7]='W';
              break;
            case 'W':
              low[7]='X';
              break;
            case 'X':
              low[7]='A';
              break;
            case 'A':
              low[7]='E';
              break;
            case 'E':
              low[7]='I';
              break;
            case 'I':
              low[7]='O';
              break;
            case 'O':
              low[7]='U';
              break;
            case 'U':
              low[7]='Y';
              break;
            case 'Y':
              low[7]='Z';
              break;
            case 'Z':
              while((d<7)&&(low[d]==high[d]))d++;
              if(d==7){
                goto QUIT;
              }
              low[7]='b';
              j=6;
              while((low[j]=table[low[j]])=='\0'){
                low[j]=table[low[j]];
                j--;
              }
              if(f&&low[f-1]!='\0')f--;
              break;
          }
          goto LOOP;
QUIT:
          }
          
        } else {
/*fprintf(stderr,"Finished or invalid response\n");*/
          exit(1);
        }
      }
    }
  }while(1);

  return result;
}
