#include <stdio.h>
#include <stdlib.h>

#include "obn.hpp"
#include "randprime.hpp"

#include "rsa.hpp"

int main(int, char **)
{
	WORD wKeySize;
	
	do {
		printf("Select keypair key size:\n");
		printf("   1.   768 bits - commercial grade\n");
		printf("   2.  1024 bits - high commercial grade\n");
		printf("   3.  2048 bits - military grade\n");
		printf("Choose 1, 2 or 3, or enter number of bits.\n");
		printf("(768 - 2048): ");
		
		scanf("%d", &wKeySize);
		switch (wKeySize) {
			case 1:
				wKeySize = 768;
			break;
			case 2:
				wKeySize = 1024;
			break;
			case 3:
				wKeySize = 2048;
			break;
		}
	} while (wKeySize < 768 || wKeySize > 2048);

	CBigNumber pub(0x10001);
	CRandomPrimeBigNumber p(wKeySize / 2);
	while (CBigNumber::GCD(pub, p - 1) != 1)
		p.SetRandom();
	CRandomPrimeBigNumber q(wKeySize / 2);
	while (CBigNumber::GCD(pub, q - 1) != 1)
		q.SetRandom();
	CBigNumber n = p * q;
	CBigNumber phi = (p - 1) * (q - 1);
	CBigNumber sec = CBigNumber::ModInv(pub, phi);
	
	CRandomBigNumber::Destroy();
	
	FILE *fpPrivate = fopen("/etc/passwdd.prk", "w");
	if (NULL == fpPrivate) {
		fprintf(stderr, "Error opening passwdd.prk...\n");
		return 1;
	}
	fprintf(fpPrivate, "-----BEGIN RSA PRIVATE KEY-----\n");
	int i;
	i = sec.Rad64Print(fpPrivate, 0);
	i = n.Rad64Print(fpPrivate, i);
	i = p.Rad64Print(fpPrivate, i);
	i = q.Rad64Print(fpPrivate, i);
	i = phi.Rad64Print(fpPrivate, i);
	if (i % 64 != 0)
		putc('\n', fpPrivate);
	fprintf(fpPrivate, "-----END RSA PRIVATE KEY-----\n");
	fclose(fpPrivate);
	
	FILE *fpPublic = fopen("/etc/passwdd.pbk", "w");
	if (NULL == fpPublic) {
		fprintf(stderr, "Error opening passwdd.pbk...\n");
		return 1;
	}
	fprintf(fpPublic, "-----BEGIN RSA PUBLIC KEY-----\n");
	i = pub.Rad64Print(fpPublic, 0);
	n.Rad64Print(fpPublic, i);
	if (i % 64 != 0)
		putc('\n', fpPublic);
	fprintf(fpPublic, "-----END RSA PUBLIC KEY-----\n");
	fclose(fpPublic);

	printf("Keypair successfully created...\n");

	return 0;
}