/*
 * Random numbers object library
 * Written by Alexander Feldman <alex@varna.net>
 * (c) Copyright 1999
 */

#include <stdio.h>
#include <stdlib.h>

#include "randprime.hpp"

char szProgress[] = "|/-\\";
int iProgress = 0;

CRandomPrimeBigNumber::CRandomPrimeBigNumber(WORD wBits) : CRandomBigNumber(wBits)
{
	if (0 != wBits) {
		pwBigNumber[0] |= 1;
		pwBigNumber[wWords - 1] |= 0x80000000;
	}
	while (!SmallPrimeDivisibilityTest() ||
			 !RabinMillerIsPrime() ||
			 !FermatIsPrime()) {
		CRandomBigNumber::SetRandom();
		printf("%c\b", szProgress[iProgress % (sizeof(szProgress) - 1)]);
		iProgress += 1;
// Need to invoke callback here
		fflush(stdout);
	}
}

CRandomPrimeBigNumber::~CRandomPrimeBigNumber()
{
}

void CRandomPrimeBigNumber::SetRandom()
{
	CRandomBigNumber::SetRandom();
	pwBigNumber[0] |= 1;
	pwBigNumber[wWords - 1] |= 0x80000000;
	while (!SmallPrimeDivisibilityTest() ||
			 !RabinMillerIsPrime() ||
			 !FermatIsPrime()) {
		CRandomBigNumber::SetRandom();
		printf("%c\b", szProgress[iProgress % (sizeof(szProgress) - 1)]);
		iProgress += 1;
// Need to invoke callback here
		fflush(stdout);
	}
}