/*
 * Copyright 1999, Alexander Feldman <alex@varna.net>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of Julianne F. Haugh nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY JULIE HAUGH AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL JULIE HAUGH OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
 
#include <stdlib.h>
#include <stdio.h>
#include <time.h>

#include "rand.hpp"

bool fgInitialized = false;
CHavalDigest *pHavalDigest;
WORD wFeedBack;

// taken from the fraction part of the Golden ratio [sqrt(5) - 1] / 2.
static WORD pwStartMsg[] =
{
	0x9E3779B9L, 0x7F4A7C15L, 0xF39CC060L, 0x5CEDC834L,
   0x1082276BL, 0xF3A27251L, 0xF86C6A11L, 0xD0C18E95L,
   0x2767F0B1L, 0x53D27B7FL, 0x0347045BL, 0x5BF1827FL,
   0x01886F09L, 0x28403002L, 0xC1D64BA4L, 0x0F335E36L,
   0xF06AD7AEL, 0x9717877EL, 0x85839D6EL, 0xFFBD7DC6L,
   0x64D325D1L, 0xC5371682L, 0xCADD0CCCL, 0xFDFFBBE1L,
   0x626E33B8L, 0xD04B4331L, 0xBBF73C79L, 0x0D94F79DL,
   0x471C4AB3L, 0xED3D82A5L, 0xFEC50770L, 0x5E4AE6E5L
};

CRandomBigNumber::CRandomBigNumber(WORD wBits) : CBigNumber()
{
	if (!fgInitialized) {
		Initialize();
		fgInitialized = true;
	}

	SetWords(wBits / BITSINWORD);
	SetRandom();
}

void CRandomBigNumber::SetRandom()
{
	Random(pwBigNumber, wWords);
}

void CRandomBigNumber::Initialize()
{
	WORD pwSeed[32];
	WORD wSeedLength;
		
	if (NULL == (pHavalDigest = new CHavalDigest()))
		return;
	
	memcpy(pwBlock, pwStartMsg, 128);

	wSeedLength = 32;
	FILE *fpSeed = fopen("random.bin", "rb");
	if (NULL == fpSeed)
		fpSeed = fopen("/dev/random", "rb");
	fread(pwSeed, sizeof(WORD), 32, fpSeed);
	fclose(fpSeed);
		
	for (WORD i = 0; i < wSeedLength; i++)
		pwBlock[i] ^= pwSeed[i & 0x1f];
		
	wFeedBack = *pwSeed & 0x18;		// 00011000B
}

void CRandomBigNumber::Random(WORD *pwRandom, WORD wLength)
{
	WORD pwSaveFingerPrint[32];
	WORD i;
	for (i = 0; i < wLength; i += 6) {
		memcpy(pwSaveFingerPrint, pwFingerPrint, 32);
		HashBlock();
		memcpy((BYTE *)(pwRandom + i), pwFingerPrint, 6 * sizeof(WORD));
		for (WORD j = 0; j < 8; j++)
			pwBlock[wFeedBack + j] ^= pwFingerPrint[j];
		wFeedBack = 0x18 & (pwFingerPrint[6] ^ pwFingerPrint[7]);
		memcpy(pwFingerPrint, pwSaveFingerPrint, 32);
	}
	if (0 != wLength % 6) {
		memcpy(pwSaveFingerPrint, pwSaveFingerPrint, 32);
		HashBlock();
		memcpy((BYTE *)(pwRandom + i), pwFingerPrint, (wLength % 6) * sizeof(WORD));
		for (WORD j = 0; j < 8; j++)
			pwBlock[wFeedBack + j] ^= pwFingerPrint[j];
		wFeedBack = 0x18 & (pwFingerPrint[6] ^ pwFingerPrint[7]);
	}
}

void CRandomBigNumber::Destroy()
{
	if (false == fgInitialized)
		return;
	
	CRandomBigNumber cSeed(1024);
	
	FILE *fpSeed = fopen("random.bin", "wb");
	fwrite(cSeed.GetData(), sizeof(WORD), 32, fpSeed);
	fclose(fpSeed);
	
	delete pHavalDigest;
	fgInitialized = false;
}