/*
 * Prime numbers object library
 * Written by Alexander Feldman <alex@varna.net>
 * (c) Copyright 1999
 */

#include <stdlib.h>

#include "prime.hpp"
#include "smallprimes.h"

CPrimeBigNumber::CPrimeBigNumber() : CBigNumber()
{
}

CPrimeBigNumber::CPrimeBigNumber(WORD wValue) : CBigNumber(wValue)
{
}

CPrimeBigNumber::~CPrimeBigNumber()
{
}

bool CPrimeBigNumber::SmallPrimeDivisibilityTest()
{
	for (unsigned i = 0; i < sizeof(iSmallPrimes) / sizeof(int); i++)
		if (*this % iSmallPrimes[i] == 0)
			return false;
	return true;
}

// Perform Rabin - Miller's probabilistic test whether the given number is
// prime
bool CPrimeBigNumber::RabinMillerIsPrime()
{
	CBigNumber w = *this - 1;
	
	WORD v = 0;
	while (w % 2 == 0) {
		v += 1;
		w >>= 1;
	}
	
	for (WORD j = 1; j <= 8; j++) {
		CBigNumber a((WORD)((float)rand() * (sizeof(iSmallPrimes) / sizeof(int)) / RAND_MAX));
		a = a % *this;
		a += 1;
		CBigNumber b = ModExp(a, w, *this);
		if ((b != 1) && (b != *this - 1)) {
			WORD i = 1;
			while (1) {
				if (i == v)
					return false;
				b = b * b % *this;
				if (b == *this - 1)
					break;
				if (b == 1)
					return false;
				i += 1;
			}
		}
	}
	
	return true;
}
 
// Test based on Fermat's theorem for prime number
bool CPrimeBigNumber::FermatIsPrime()
{
	CBigNumber a(2);
	CBigNumber b = *this;
	CBigNumber c = *this;
	
	c -= 1;
	
	CBigNumber d = ModExp(a, c, b);
	
	if (d == 1)
		return true;
	return false;
}