#ifndef __UTMP_HPP__
#define __UTMP_HPP__

#include <signal.h>
#include <utmp.h>

#include "conf.hpp"

#define CE_HOSTSIZE		48

typedef struct
{
	char szLogin[UT_NAMESIZE + 1];
	char szDevice[UT_LINESIZE + 1];
	char szHost[CE_HOSTSIZE + 1];
} SUtmpEntry;

class CUtmpFile
{
	public:
		CUtmpFile(CConfigurationFile *, char **);
		~CUtmpFile();
	
	public:
		bool ExistsDevice(char *);
		void EnumUtmp(void(*)(char *, char *, void *), void *);
		void KillUser(char *, char *);
	
	private:
		bool IsUserAllowed(char *, char **);
	
	public:
		void Dump();
	
	public:
		bool GetFirstRecord(SUtmpEntry *);
		bool GetNextRecord(SUtmpEntry *);
	
	private:
		int iRecords;
		int iCurrent;
		struct utmp *pRecords;
		CConfigurationFile *pConf;
};

#endif // __UTMP_HPP__