/*
 * Copyright 1999, Alexander Feldman <alex@varna.net>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of Alexander Feldman nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY ALEXANDER FELDMAN AND CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL ALEXANDER FELDMAN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */
 
#include <stdlib.h>
#include <syslog.h>
#include <string.h>
#include <unistd.h>
#include <errno.h>
#include <pwd.h>
#include <grp.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <netdb.h>

#include "sockio.hpp"
#include "server.hpp"
#include "conf.hpp"
#include "logfile.hpp"
#include "logged.hpp"
#include "utmp.hpp"

extern CConfigurationFile *pConfigFile;

void server(int sockfd)
{
	char szLogin[UT_NAMESIZE + 1];
	char szDevice[UT_LINESIZE + 1];
	char szHost[CE_HOSTSIZE];
	
	write_byte(sockfd, WELCOME);
	
	if ((-1 == read_string(sockfd, szLogin, sizeof(szLogin))) ||
		 (-1 == read_string(sockfd, szDevice, sizeof(szDevice))) ||
		 (-1 == read_string(sockfd, szHost, sizeof(szHost)))) {
		write_byte(sockfd, TIMEOUT);
		return;
	}
	
	char *pszMessage;
	
	CUtmpFile cUtmp(pConfigFile, &pszMessage);
	if (NULL != pszMessage) {
		lprintf("%s\n", pszMessage);		
		write_byte(sockfd, ERROR);
		return;
	} 
	
	CLoggedDatabase cLoggedDatabase(pConfigFile, &pszMessage);
	if (NULL != pszMessage) {
		lprintf("%s\n", pszMessage);		
		write_byte(sockfd, ERROR);
		return;
	}
	
	if (false == cLoggedDatabase.CheckRecord(szLogin, szDevice, szHost)) {
		write_byte(sockfd, INVALID_USER);
		return;
	}
	cUtmp.KillUser(szLogin, szDevice);
	cLoggedDatabase.DeleteRecord(szHost);
	
	write_byte(sockfd, OK);
}