#ifndef __LOGGED_HPP__
#define __LOGGED_HPP__

#include <time.h>
#include <gdbm.h>
#include <utmp.h>

#include "conf.hpp"

#define CE_HOSTSIZE		48

#define MAX_PATH		 1024
#define LOCK_TRIES		15
#define LOCK_SLEEP		 1

typedef struct 
{
	char szLogin[UT_NAMESIZE + 1];
	char szDevice[UT_LINESIZE + 1];
	char szHost[CE_HOSTSIZE];
} SLoggedEntry;

class CLoggedDatabase
{
	public:
		CLoggedDatabase(CConfigurationFile *, char **, bool fgReadOnly = false);
		~CLoggedDatabase();
	
	public:
		bool AddRecord(char *, char *, char *);
		bool ExistsRecord(char *);
		bool CheckRecord(char *, char *, char *);
		void DeleteRecord(char *);
		void EnumCurrent(void (*)(char *, char *, char *));
		bool GetFirstRecord(SLoggedEntry *);
		bool GetNextRecord(SLoggedEntry *);

	private:
		bool fgReadOnly;
		datum strLoggedKey;
		char szLoggedDatabase[128];
		GDBM_FILE dbfLogged;
};

#endif // __LOGGED_HPP__