#include <stdio.h>
#include <utmp.h>
#include <pwd.h>
#include <grp.h>
#include <string.h>
#include <sys/types.h>
#include <gdbm.h>
#include <time.h>
#include <stdlib.h>
#include <signal.h>

#include "conf.hpp"

GDBM_FILE dbfHronoNew;
GDBM_FILE dbfHronoOld;

typedef struct {
	char szLogin[UT_NAMESIZE + 1];
	char szDevice[UT_LINESIZE + 1];
	char szHost[48];	
	time_t tStartTime;
	time_t tFinalTime;
	time_t tLoginTime;		// tFinalTime - tStartTime
	int iInputTraffic;
	int iOutputTraffic;
	int iTotalTraffic;		// iInputTraffic + iOutputTraffic
} HRONO_ENTRY;			// The key of this database is the login name

typedef struct {
        char szLogin[UT_NAMESIZE + 1];
        char szDevice[UT_LINESIZE + 1];
        time_t tStartTime;
        time_t tFinalTime;
        time_t tLoginTime;              // tFinalTime - tStartTime
        int iInputTraffic;
        int iOutputTraffic;
        int iTotalTraffic;              // iInputTraffic + iOutputTraffic
} OLD_HRONO_ENTRY;    // The key of this database is the login name


int main(int argc, char **argv)
{
	if (argc != 3)
		return 1;
	
	dbfHronoNew = gdbm_open(argv[2], 0, GDBM_WRCREAT, 0644, NULL);
	dbfHronoOld = gdbm_open(argv[1], 0, GDBM_READER, 0, NULL);
	
	if (NULL == dbfHronoNew || NULL == dbfHronoOld)
		return 0;
	
	
	datum strHronoKey;
	datum strNextHronoKey;
	
	HRONO_ENTRY strNew;
	OLD_HRONO_ENTRY strOld;
	
	int i = 0;
	
	strHronoKey = gdbm_firstkey(dbfHronoOld);
	while (strHronoKey.dptr) {
		strNextHronoKey = gdbm_nextkey(dbfHronoOld, strHronoKey);
		
		memset(&strNew, 0, sizeof(HRONO_ENTRY));
		
		datum strHronoData = gdbm_fetch(dbfHronoOld, strHronoKey);
		memcpy(&strOld, strHronoData.dptr, strHronoData.dsize);
		free(strHronoData.dptr);
		
		strcpy(strNew.szLogin, strOld.szLogin);
		strcpy(strNew.szDevice, strOld.szDevice);
		strcpy(strNew.szHost, "?");	
		strNew.tStartTime = strOld.tStartTime;
		strNew.tFinalTime = strOld.tFinalTime;
		strNew.tLoginTime = strOld.tLoginTime;
		strNew.iInputTraffic = strOld.iInputTraffic;
		strNew.iOutputTraffic = strOld.iOutputTraffic;
		strNew.iTotalTraffic = strOld.iTotalTraffic;

		datum strNewHronoKey;
		datum strNewHronoData;

		char *pszBuffer = new char[sizeof(time_t) + strlen(strNew.szLogin) + 128];
//		printf("%d %s\n", sizeof(time_t) + strlen(strNew.szLogin) + 1, strNew.szLogin);

		do {
			memcpy(pszBuffer, &strNew.tStartTime, sizeof(time_t));
			memcpy(pszBuffer + sizeof(time_t), strNew.szLogin, strlen(strNew.szLogin));

			strNewHronoKey.dptr = pszBuffer;
			strNewHronoKey.dsize = sizeof(time_t) + strlen(strNew.szLogin);
			
			strNew.tStartTime += 1;
		} while (true == gdbm_exists(dbfHronoNew, strNewHronoKey));
		strNewHronoData.dptr = (char *)&strNew;
		strNewHronoData.dsize = sizeof(HRONO_ENTRY);
		gdbm_store(dbfHronoNew, strNewHronoKey, strNewHronoData, GDBM_REPLACE);
		delete pszBuffer;
		i += 1;
		free(strHronoKey.dptr);		
		strHronoKey = strNextHronoKey;
	}
	
	printf("%d records moved...\n", i);
	
	gdbm_close(dbfHronoNew);
	gdbm_close(dbfHronoOld);
	
	return 0;
}