#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <time.h>
#include <ctype.h>

#include "tokenized_string.hpp"
#include "util.hpp"

char *GetTraffic(int iTraffic)
{
	static char szResult[128];
	char szTmp1[32];
	char szTmp2[32];
	char szTmp3[32];
	char szTmp4[32];
	
	int gb = iTraffic / (1024 * 1024 * 1024);
	int mb = (iTraffic / (1024 * 1024)) % 1024;
	int kb = (iTraffic / 1024) % 1024;
	int bb = iTraffic % 1024;
	
	snprintf(szTmp1, sizeof(szTmp1), "%dGB ", gb);
	snprintf(szTmp2, sizeof(szTmp2), "%dMB ", mb);
	snprintf(szTmp3, sizeof(szTmp3), "%dKB ", kb);
	snprintf(szTmp4, sizeof(szTmp4), "%dB", bb);
	
	snprintf(szResult,
				sizeof(szResult),
				"%s%s%s%s",
				gb == 0 ? "" : szTmp1,
				mb == 0 ? "" : szTmp2,
				kb == 0 ? "" : szTmp3,
				szTmp4);
	
	return szResult;
}

char *GetTime(time_t tTime)
{
	static char szResult[128];
	
	snprintf(szResult,
				sizeof(szResult),
				"%02ld:%02ld:%02ld",
				tTime / 3600,
				(tTime / 60) % 60,
				tTime %60);
	
	return szResult;
}

int CalcTraffic(char *pszTraffic)
{
	char szTraffic[64];
	char szMask[32];
	
	int i, j;
	for (i = 0, j = 0; pszTraffic[i] != '\0'; i++)
		if (' ' != pszTraffic[i] &&
			 !('b' == tolower(pszTraffic[i]) &&
			   ('g' == tolower(pszTraffic[i - 1]) ||
			 	 'm' == tolower(pszTraffic[i - 1]) ||
				 'k' == tolower(pszTraffic[i - 1]) ||
				 'b' == tolower(pszTraffic[i - 1]))))
			szTraffic[j++] = tolower(pszTraffic[i]);
	szTraffic[j] = '\0';
	
	if (j && isdigit(szTraffic[j - 1]))
		strcat(szTraffic, "b");
	
	for (i = 0, j = 0; szTraffic[i] != '\0'; i++)
		if (!isdigit(szTraffic[i]))
			szMask[j++] = szTraffic[i];
	szMask[j] = '\0';
	
	CTokenizedString cResult(szTraffic, szMask);

	int iResult = 0;
	for (int i = 0; i < (int)strlen(szMask); i++) {
		char *pszValue = cResult.GetString(i);
		if ('\0' == *pszValue || NULL == pszValue)
			return -1;
		switch (szMask[i]) {
			case 'g':
				iResult += 1024 * 1024 * 1024 * atoi(pszValue);
			break;
			case 'm':
				iResult += 1024 * 1024 * atoi(pszValue);
			break;
			case 'k':
				iResult += 1024 * atoi(pszValue);
			break;
			case 'b':
				iResult += atoi(pszValue);
			break;
			default:
				return -1;
		}
	}
	
	return iResult;
}

time_t CalcTime(char *pszTime)
{
	char szTime[64];
	char szMask[32];
	
	int i, j;
	for (i = 0, j = 0; pszTime[i] != '\0'; i++)
		if (' ' != pszTime[i])
			szTime[j++] = tolower(pszTime[i]);
	szTime[j] = '\0';
	
	if (j && isdigit(szTime[j - 1]))
		strcat(szTime, "s");
	
	for (i = 0, j = 0; szTime[i] != '\0'; i++)
		if (!isdigit(szTime[i]))
			szMask[j++] = szTime[i];
	szMask[j] = '\0';
	
	CTokenizedString cResult(szTime, szMask);

	time_t tResult = 0;
	for (int i = 0; i < (int)strlen(szMask); i++) {
		char *pszValue = cResult.GetString(i);
		if ('\0' == *pszValue || NULL == pszValue)
			return -1;
		switch (szMask[i]) {
			case 'h':
				tResult += 3600 * atoi(pszValue);
			break;
			case 'm':
				tResult += 60 * atoi(pszValue);
			break;
			case 's':
				tResult += atoi(pszValue);
			break;
			default:
				return -1;
		}
	}
	
	return tResult;
}