#include <string.h>
#include <assert.h>

#include "trim.hpp"

char *TrimLeft(char *pszString, char *pszChars)
{
	assert(pszString);
	assert(pszChars);
	
	int k = strspn(pszString, pszChars);
	int l = strlen(pszString);
	int i;
	if (0 != k) {
		for (i = k; i < l; i++)
			pszString[i - k] = pszString[i];
		pszString[i - k] = '\0';
	}
	return pszString;
}

char *TrimRight(char *pszString, char *pszChars)
{
	assert(pszString);
	assert(pszChars);
	
	int i = strlen(pszString) - 1;
	for (; i >= 0; i--)
		if (NULL == strchr(pszChars, pszString[i]))
			break;
	pszString[i + 1] = '\0';
	return pszString;
}

char *TrimBoth(char *pszString, char *pszChars)
{
	assert(pszString);
	assert(pszChars);
	
	return TrimLeft(TrimRight(pszString, pszChars), pszChars);
}