#include <stdlib.h>
#include <string.h>
#include <assert.h>

#include "tokenized_string.hpp"

CTokenizedString::CTokenizedString(char *pszString, char *pszDelimiters) : CStringArray()
{
	assert(pszString);
	assert(pszDelimiters);
	
	char *pszStartOfToken;
	char *pszEndOfToken;
	for (pszStartOfToken = pszEndOfToken = pszString; *pszString != '\0'; pszString++)
		for (int j = 0; pszDelimiters[j] != '\0'; j++)
			if (*pszString == pszDelimiters[j]) {
				pszEndOfToken = pszString;
				AddString(pszStartOfToken, pszEndOfToken - pszStartOfToken);
				pszStartOfToken = pszString + 1;
			}
	pszEndOfToken = pszString;
	AddString(pszStartOfToken, pszEndOfToken - pszStartOfToken);
	pszStartOfToken = pszString + 1;
}