#include <stdlib.h>
#include <string.h>
#include <assert.h>

#include "string_array.hpp"

CStringArray::~CStringArray()
{
	for (int i = 0; i < iStrings; i++)
		delete ppszStrings[i];
	delete ppszStrings;
}

bool CStringArray::AddString(char *pszString, int iLength)
{
	assert(pszString);
	
	if (-1 == iLength)
		iLength = strlen(pszString);
	char *pszNewString = new char[iLength + 1];
	if (NULL == pszNewString)
		return false;
	memcpy(pszNewString, pszString, iLength);
	pszNewString[iLength] = '\0';
	char **ppszNewStrings = (char **)realloc(ppszStrings, sizeof(char *) * (iStrings + 1));
	if (NULL == ppszNewStrings) {
		delete pszNewString;
		return false;
	}
	
	ppszStrings = ppszNewStrings;
	
	ppszStrings[iStrings] = pszNewString;
	
	iStrings += 1;
	
	return true;
}

char *CStringArray::GetString(int iNum)
{
	assert(iNum >= 0 && iNum < iStrings);
	
	if (iNum >= 0 && iNum < iStrings)
		return ppszStrings[iNum];
	
	return NULL;
}

char *CStringArray::GetFirstString()
{
	if (0 == iStrings)
		return NULL;
	
	iCurrent = 0;
	
	return ppszStrings[0];
}

char *CStringArray::GetNextString()
{
	if (iCurrent + 1 >= iStrings)
		return NULL;
	
	iCurrent += 1;
	
	return ppszStrings[iCurrent];
}