#ifndef WIN32
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <netinet/in.h>

#include "config.h"
#else
#include "winsock2.h"
#endif

#include "sockio.hpp"

#ifdef CRYPTED_PASSWORDS
        #include "rsa.hpp"
#endif

#define PASSWORD_BUFFER_SIZE 128

#ifndef WIN32
#define READ read
#define WRITE write
#else
#define READ(fd, buf, cnt) recv((fd), (buf), (cnt), 0)
#define WRITE(fd, buf, cnt) send((fd), (buf), (cnt), 0)
#endif

int read_string(int sockfd, char *pszString, int iMaxLength)
{
	char c;
	int i, j;

// TODO - It'll be more faster to read bigger junks of data.
//             We need also some additional error handling.
	for (i = 0; i < iMaxLength - 1; i++) {
		if (1 == (j = READ(sockfd, &c, 1))) {
			if ('\0' == c)
				break;
			*pszString++ = c;
		} else if (0 == j)                                      // EOF
			break;
		else
			return -1;                                   // Error
	}

	*pszString = '\0';
	return i;
}

int write_string(int sockfd, char *pszString)
{
	int iResult = WRITE(sockfd, pszString, strlen(pszString) + 1);

	if ((int)(strlen(pszString) + 1) != iResult)
		return -1;                                      // Error

	return iResult;
}

int read_integer(int sockfd, int *pi)
{
	bool fgResult = (READ(sockfd, (char *)pi, sizeof(int)) == sizeof(int));

	*pi = ntohl(*pi);

	return fgResult;
}

int write_integer(int sockfd, int i)
{
	int j = htonl(i);
	return (WRITE(sockfd, (char *)&j, sizeof(j)) == sizeof(j));
}

int read_byte(int sockfd, unsigned char *pc)
{
	return (READ(sockfd, (char *)pc, sizeof(unsigned char)) == sizeof(unsigned char));
}

int write_byte(int sockfd, unsigned char c)
{
	return (WRITE(sockfd, (char *)&c, sizeof(unsigned char)) == sizeof(unsigned char));
}

void *read_data(int sockfd, int *piDataLength)
{
	if (!read_integer(sockfd, piDataLength))
		return NULL;

	if (*piDataLength < MAX_DATA) {
		void *pvResult = calloc(*piDataLength, 1);
		if (NULL == pvResult)
			return NULL;
		if (*piDataLength != READ(sockfd, (char *)pvResult, *piDataLength)) {
			free(pvResult);
			return NULL;
		}
		return pvResult;
	}
	return NULL;
}

int write_data(int sockfd, void *pvData, int iDataLength)
{
	if (!write_integer(sockfd, iDataLength))
		return -1;

	int iResult = WRITE(sockfd, (const char *)pvData, iDataLength);

	if (iResult != iDataLength)
		return -1;

	return iResult;
}

char *read_password(int sockfd)
{
#ifdef CRYPTED_PASSWORDS
	int iDataLength;
	
	void *pvEncryptedData = read_data(sockfd, &iDataLength);
	if (NULL == pvEncryptedData)
		return NULL;
	char *pszPassword = RSADecryptString(pvEncryptedData);
	free(pvEncryptedData);

	return pszPassword;
#else
	char *pszPassword = (char *)calloc(PASSWORD_BUFFER_SIZE, 1);
	if (NULL == pszPassword)
		return NULL;

	if (-1 == read_string(sockfd, pszPassword, PASSWORD_BUFFER_SIZE))
		return NULL;

	return pszPassword;
#endif // CRYPTED_PASSWORDS
}

bool write_password(int sockfd, char *pszPassword)
{
#ifdef CRYPTED_PASSWORDS
	void *pvEncryptedData = RSAEncryptString(pszPassword);

	write_data(sockfd, pvEncryptedData, ((unsigned int *)pvEncryptedData)[0]);

	free(pvEncryptedData);

	 return true;
#else
	if ((int)strlen(pszPassword) + 1 != write_string(sockfd, pszPassword))
		return false;

	return true;
#endif
}