#include <string.h>
#include <stdlib.h>
#include <stdio.h>
#include <netdb.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>

#include "resolv.h"

char *naddr2str(struct sockaddr_in *saptr) {
	static char szResult[256];
	char *bp, *ap;
	int l;
	struct sockaddr sa;
	
// Check for null/zero family
	if (saptr == NULL)
		return "NULLADDR";
	if (saptr->sin_family == 0)
		return "0";

	switch (saptr->sin_family) {
//		case AF_UNIX:
//			if (saptr->sunix.sun_path[0] != '\0')
//				snprintf(str, 256, "[UNIX: %.64s]", saptr->sunix.sun_path);
//			else
//				snprintf(str, 256, "[UNIX: localhost]");
//			return str;
		case AF_INET:
			return inet_ntoa(saptr->sin_addr);
	}

// Unknown family -- just dump bytes
	memcpy(&sa, saptr, sizeof(sa));
	snprintf(szResult, 256, "Family %d: ", sa.sa_family);
	bp = &szResult[strlen(szResult)];
	ap = sa.sa_data;
	for (l = sizeof(sa.sa_data); --l >= 0; ) {
		sprintf(bp, "%02x:", *ap++ & 0377);
		bp += 3;
	}
	*--bp = '\0';
	return szResult;
}

unsigned long nname2h(char *pszName, bool *pfgError)
{
	struct hostent *pstrHost;
	
	pstrHost = gethostbyname(pszName);
	if (NULL == pstrHost) {
		*pfgError = true;
		return 0;
	}
	*pfgError = false;
	return ntohl(*((unsigned long int *)(pstrHost->h_addr)));
}

bool naddr2h(char *pszHost,
				 unsigned long int *pulTargetHost,
				 unsigned long int *pulTargetMask,
				 bool *pfgInvert)
{
	bool fgError = false;
	
	char *pszMask;
	
	char *pszTmp = new char[strlen(pszHost) + 1];
	if (NULL == pszTmp)
		return false;
	
	pszHost = strcpy(pszTmp, pszHost);
	if (NULL != (pszMask = strchr(pszHost, '/'))) {
		*pszMask = '\0';
		pszMask += 1;
	}
	*pfgInvert = false;
	if ('!' == *pszHost) {
		*pfgInvert = true;
		pszHost += 1;
	}
	*pulTargetHost = nname2h(pszHost, &fgError);
	if (true == fgError) {
		delete pszTmp;
		return false;
	}
	*pulTargetMask = 0xFFFFFFFF;
	if (NULL != pszMask) {
		char *p;
		unsigned long l = strtol(pszMask, &p, 10);
		if (('\0' == *p) && (l >= 0) && (l <= 32)) {
			*pulTargetMask = 0;
			for (unsigned long q = 0; q < l; q++) {
				*pulTargetMask >>= 1;
				*pulTargetMask |= 0x80000000;
			}
		} else
			*pulTargetMask = nname2h(pszMask, &fgError);
	}
	
	delete pszTmp;
	return !fgError;
}